/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import woolpack.TestUtils;

import junit.framework.TestCase;

public class EqualsValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new EqualsValidator(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testInterpret(){
		final ValidatorExpression expression = new EqualsValidator("a4");
		final ValidatorContext context = new ValidatorContext();
		context.setInputMap(new HashMap<String,List<Object>>());
		context.setTmpKey("key0");
		
		context.setTmpValue("a4");
		assertTrue(expression.interpret(context));
		assertTrue(TestUtils.equals("#{\"key0\":{\"a4\"}}", context.getInputMap()));

		context.setTmpValue("aa");
		assertFalse(expression.interpret(context));
		assertTrue(TestUtils.equals("#{\"key0\":{\"aa\"}}", context.getInputMap()));

		context.setTmpValue(null);
		assertFalse(expression.interpret(context));
		assertTrue(TestUtils.equals("#{\"key0\":{null}}", context.getInputMap()));
	}
	
	public void testAppendTo() throws IOException{
		final ValidatorExpression expression = new EqualsValidator("a4");
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new EqualsValidator(\"a4\")", sb.toString());
	}
	
	public void testAddMessageTo(){
		final ValidatorExpression expression = new EqualsValidator("a4");
		final Collection<String> expectedCollection = new ArrayList<String>();
		expression.addMessageTo(expectedCollection);
		assertTrue(expectedCollection.isEmpty());
	}
}
