/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import junit.framework.TestCase;

public class DelegationSetTest extends TestCase {
	private Set<String> collection = new DelegationSet<String>(new HashSet<String>());

	public void testConstructor(){
		try{
			new DelegationSet<String>(null);
			fail();
		}catch(NullPointerException expected){
		}
	}
	
	public void testNormal(){
		collection.add("value0");
		{
			final Collection<String> tmpMap = new ArrayList<String>();
			tmpMap.add("value1");
			tmpMap.add("value2");
			collection.addAll(tmpMap);
		}
		
		{
			final Collection<String> expected = new ArrayList<String>();
			expected.add("value0");
			expected.add("value1");
			expected.add("value2");
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertFalse(collection.isEmpty());
		assertEquals(3, collection.size());
		assertTrue(collection.contains("value0"));
		assertTrue(collection.contains("value1"));
		assertTrue(collection.contains("value2"));
		
		collection.remove("value2");
		
		{
			final Collection<String> expected = new ArrayList<String>();
			expected.add("value0");
			expected.add("value1");
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertFalse(collection.isEmpty());
		assertEquals(2, collection.size());
		assertTrue(collection.contains("value0"));
		assertTrue(collection.contains("value1"));
		assertFalse(collection.contains("value2"));
		
		collection.clear();
		
		{
			final Collection<String> expected = new ArrayList<String>();
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertTrue(collection.isEmpty());
		assertEquals(0, collection.size());
		assertFalse(collection.contains("value0"));
		assertFalse(collection.contains("value1"));
		assertFalse(collection.contains("value2"));
	}

	
	public void testRemoveAllRetainAll(){
		collection.add("value0");
		{
			final Collection<String> tmpMap = new ArrayList<String>();
			tmpMap.add("value1");
			tmpMap.add("value2");
			collection.addAll(tmpMap);
		}
		
		{
			final Collection<String> expected = new ArrayList<String>();
			expected.add("value0");
			expected.add("value1");
			expected.add("value2");
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertFalse(collection.isEmpty());
		assertEquals(3, collection.size());
		assertTrue(collection.contains("value0"));
		assertTrue(collection.contains("value1"));
		assertTrue(collection.contains("value2"));
		
		{
			final Collection<String> tmpCollection = new ArrayList<String>();
			tmpCollection.add("value2");
			collection.removeAll(tmpCollection);
		}
		
		{
			final Collection<String> expected = new ArrayList<String>();
			expected.add("value0");
			expected.add("value1");
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertFalse(collection.isEmpty());
		assertEquals(2, collection.size());
		assertTrue(collection.contains("value0"));
		assertTrue(collection.contains("value1"));
		assertFalse(collection.contains("value2"));

		{
			final Collection<String> tmpCollection = new ArrayList<String>();
			tmpCollection.add("value1");
			collection.retainAll(tmpCollection);
		}
		
		{
			final Collection<String> expected = new ArrayList<String>();
			expected.add("value1");
			assertTrue(expected.containsAll(collection));
			assertTrue(collection.containsAll(expected));
			
			final Collection<String> tmpCollection = new ArrayList<String>();
			for(final String s:collection){
				tmpCollection.add(s);
			}
			assertTrue(expected.containsAll(tmpCollection));
			assertTrue(tmpCollection.containsAll(expected));

			assertTrue(expected.containsAll(Arrays.asList(collection.toArray())));
			assertTrue(Arrays.asList(collection.toArray()).containsAll(expected));
		}
		assertFalse(collection.isEmpty());
		assertEquals(1, collection.size());
		assertFalse(collection.contains("value0"));
		assertTrue(collection.contains("value1"));
		assertFalse(collection.contains("value2"));
	}
}
