/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.sql.Date;

import junit.framework.TestCase;

public class ToSQLDateFormatTest extends TestCase {

	public void testConstructor(){
		try{
			new ToSQLDateFormat(null);
			fail();
		}catch(final NullPointerException e){
		}
	}
	
	private void scenario(final Format format) throws ParseException{
		final Date date = new Date(new SimpleDateFormat("yyyyMMdd").parse("20060601").getTime());
		assertEquals("20060601", format.format(date));
		assertEquals(date, format.parseObject("20060601"));
		try{
			format.parseObject("yyyyMMdd");
			fail();
		}catch(final ParseException expected){
			
		}
	}

	public void testNormal() throws ParseException{
		final Format format0 = new ToSQLDateFormat(new SimpleDateFormat("yyyyMMdd"));
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}

	public void testNormal2() throws ParseException{
		final Format format0 = new ToSQLDateFormat(new SimpleDateFormat("yyyyMMdd"));
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
}
