/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.dom.XPathAttrValue;
import woolpack.utils.OGE;

public class UpdateToSelectedValueTest extends TestCase {

	public void testConstructor(){
		try{
			new UpdateToSelectedValue(null, OGE.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody("<SPAN id=\"id0\" />"),
				new XPathAttrValue("id", "id0", new UpdateToSelectedValue(new OGE("local.value0"), new OGE("local.list0"))));
		final DomContext context = new DomContext();
		new OGE("local.value0 = \"v1\", local.list0 = #{\"v0\":\"l0\", \"v1\":\"l1\"}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equals(context, "<SPAN id=\"id0\" >l1</SPAN>"));
	}
	
	public void testNull(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeBody("<SPAN id=\"id0\" />"),
				new XPathAttrValue("id", "id0", new UpdateToSelectedValue(new OGE("local.value0"), new OGE("local.list0"))));
		final DomContext context = new DomContext();
		new OGE("local.list0 = #{\"v0\":\"l0\", \"v1\":\"l1\"}").getValue(context);
		
		expression.interpret(context);

		assertTrue(TestUtils.equalsBody(context, ""));
	}
}
