/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import junit.framework.TestCase;
import woolpack.config.ConfigConstants;
import woolpack.config.ConfigCount;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

public class ConfigDomExpressionTest extends TestCase {

	public void testConstructor(){
		try{
			new ConfigDomExpression(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final ConfigCount counter = new ConfigCount(ConfigConstants.MAKE_MAP);
		final DomExpression domExpression = new ConfigDomExpression(counter);
		final DomContext context = new DomContext();
		domExpression.interpret(context);
		assertEquals(1, counter.getCount());
		assertNotNull(context.getConfig());
		assertEquals(counter.getContextList().getLast().getMap(), context.getConfig());
	}
}
