/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.utils.OGE;

public class ReplaceTextTest extends TestCase {

	public void testConstructor(){
		try{
			new ReplaceText(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void test0(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("hoge<TEXTAREA name=\"name0\" >value0</TEXTAREA>piyo"),
				new XPathAttrValue("name", "name0", 
						new ReplaceText(new OGE("\"value1\""))
				)
		);
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "hogevalue1piyo"));
	}
	
	public void test1(){
		final DomExpression expression = new Serial(
				TestUtils.getToNodeForm("hoge<TEXTAREA name=\"name0\" >value0</TEXTAREA>piyo"),
				new XPathAttrValue("name", "name0", new ReplaceText(new OGE("local.value1")))
		);
		final DomContext context = new DomContext();
		new OGE("local.value1 = \"value2\"").getValue(context);
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context, "hogevalue2piyo"));
	}
}
