/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import junit.framework.TestCase;
import woolpack.action.ForwardDef;
import woolpack.action.ActionConstants;
import woolpack.utils.OGE;

public class ForwardDefTest extends TestCase {

	public void testConstructor(){
		try{
			new ForwardDef(null, OGE.NULL, ActionConstants.ANY);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ForwardDef("", OGE.NULL, ActionConstants.ANY);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new ForwardDef("forwardId0", null, ActionConstants.ANY);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ForwardDef("forwardId0", OGE.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testGet(){
		final ForwardDef def = new ForwardDef("id0");
		assertEquals(OGE.NULL, def.getComponentOGE());
		assertEquals("id0", def.getId());
		assertEquals(ActionConstants.NOT_THROWABLE, def.getMatchable());
	}
	
	public void testGet2(){
		final ForwardDef def = new ForwardDef("id0", new OGE("component0"));
		assertEquals(new OGE("component0"), def.getComponentOGE());
		assertEquals("id0", def.getId());
		assertEquals(ActionConstants.NOT_THROWABLE, def.getMatchable());
	}
	
	public void testGet3(){
		final ForwardDef def = new ForwardDef("id0", ActionConstants.ANY);
		assertEquals(OGE.NULL, def.getComponentOGE());
		assertEquals("id0", def.getId());
		assertEquals(ActionConstants.ANY, def.getMatchable());
	}
	
	public void testGet4(){
		final ForwardDef def = new ForwardDef("id0", new OGE("component0"), ActionConstants.ANY);
		assertEquals(new OGE("component0"), def.getComponentOGE());
		assertEquals("id0", def.getId());
		assertEquals(ActionConstants.ANY, def.getMatchable());
	}
}
