/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.Collection;
import java.util.Map;

import org.w3c.dom.Element;

import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.OGE;
import woolpack.utils.UtilsConstants;

/**
 * 子ノードに HTML 隠し項目を追加する{@link DomExpression}。
 * @author nakamura
 *
 */
public class HiddenAllToChild implements DomExpression {
	private final OGE mapOGE;
	private final Collection<String> excludeProperties;
	
	/**
	 * コンストラクタ。
	 * @param mapOGE hidden にする情報の{@link Map}の取得先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public HiddenAllToChild(final OGE mapOGE, final Collection<String> excludeProperties){
		mapOGE.getClass();
		excludeProperties.getClass();
		
		this.mapOGE = mapOGE;
		this.excludeProperties = excludeProperties;
	}

	/**
	 * @throws NullPointerException 引数または{@link DomContext#getNode()}または取得した{@link Map}が null の場合。
	 */
	public void interpret(final DomContext context) {
		final Map map = (Map)mapOGE.getValue(context);
		for(final Object key:map.keySet()){
			if(excludeProperties.contains(key)){
				continue;
			}
			final Iterable values = UtilsConstants.toIterable(map.get(key));
			for(final Object value:values){
				final Element e = DomConstants.getDocumentNode(context.getNode()).createElement("INPUT");
				e.setAttribute("type", "hidden");
				e.setAttribute("name", key.toString());
				e.setAttribute("value", value.toString());
				context.getNode().appendChild(e);
			}
		}
	}
}
