/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Map;

import woolpack.utils.UtilsConstants;


/**
 * {@link DomContext#getId()}で委譲先を分岐する{@link DomExpression}。
 * @author nakamura
 *
 */
public class BranchById implements DomExpression {
	private final Map<String,DomExpression> map;
	
	/**
	 * コンストラクタ。
	 * @param map id と委譲先の{@link Map}。ステートレスであるべき。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public BranchById(final Map<String,DomExpression> map){
		map.getClass();
		this.map = UtilsConstants.defaultValueMap(map, DomConstants.NULL);
	}

	/**
	 * @throws NullPointerException 引数が null の場合。
	 */
	public void interpret(final DomContext context) {
		final DomExpression expression = map.get(context.getId());
		expression.interpret(context);
	}
}
