/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountValidator
implements ValidatorExpression {
    private final int max;
    private final ValidatorExpression expression;
    private final LinkedList<ValidatorContext> contextList;
    private final LinkedList<Appendable> sbList;
    private final LinkedList<Collection<String>> collectionList;
    private volatile int intepretCount = 0;
    private volatile int appendToCount = 0;
    private volatile int addMessageToCount = 0;

    public CountValidator(int max, ValidatorExpression expression) {
        expression.getClass();
        this.max = max;
        this.expression = expression;
        this.contextList = new LinkedList();
        this.sbList = new LinkedList();
        this.collectionList = new LinkedList();
    }

    public CountValidator(ValidatorExpression expression) {
        this(4, expression);
    }

    @Override
    public boolean interpret(ValidatorContext context) {
        ++this.intepretCount;
        if (this.max > 0) {
            if (this.intepretCount > this.max) {
                this.contextList.removeFirst();
            }
            this.contextList.add(context);
        }
        return this.expression.interpret(context);
    }

    @Override
    public void appendTo(Appendable sb) throws IOException {
        ++this.appendToCount;
        if (this.max > 0) {
            if (this.appendToCount > this.max) {
                this.sbList.removeFirst();
            }
            this.sbList.add(sb);
        }
        this.expression.appendTo(sb);
    }

    @Override
    public void addMessageTo(Collection<String> messageCollection) {
        ++this.addMessageToCount;
        if (this.max > 0) {
            if (this.addMessageToCount > this.max) {
                this.collectionList.removeFirst();
            }
            this.collectionList.add(messageCollection);
        }
        this.expression.addMessageTo(messageCollection);
    }

    public int getAddMessageToCount() {
        return this.addMessageToCount;
    }

    public int getAppendToCount() {
        return this.appendToCount;
    }

    public int getIntepretCount() {
        return this.intepretCount;
    }

    public LinkedList<Collection<String>> getCollectionList() {
        return this.collectionList;
    }

    public LinkedList<ValidatorContext> getContextList() {
        return this.contextList;
    }

    public LinkedList<Appendable> getSbList() {
        return this.sbList;
    }
}

