/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Map;
import ognl.TypeConverter;
import woolpack.utils.UtilsConstants;

public class CollectionTypeConverter
implements TypeConverter {
    private final TypeConverter defaultTypeConverter;

    CollectionTypeConverter(TypeConverter defaultTypeConverter) {
        defaultTypeConverter.getClass();
        this.defaultTypeConverter = defaultTypeConverter;
    }

    public Object convertValue(Map context, Object target, Member member, String propertyName, Object beforeValue, Class toType) {
        Collection collection = UtilsConstants.toCollection(beforeValue);
        if (toType.isArray()) {
            Object afterArray = Array.newInstance(toType.getComponentType(), collection.size());
            int i = 0;
            for (Object before : collection) {
                Object after = this.defaultTypeConverter.convertValue(context, target, member, propertyName, before, toType.getComponentType());
                Array.set(afterArray, i, after);
                ++i;
            }
            return afterArray;
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return collection;
        }
        Object value = collection.iterator().next();
        if (value != null) {
            return this.defaultTypeConverter.convertValue(context, target, member, propertyName, value, toType);
        }
        return value;
    }
}

