/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.List;
import java.util.Map;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.ee.ValidatorRuntimeException;
import woolpack.utils.EmbeddingResolveable;
import woolpack.utils.OGE;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

public class ValidatorBuilder {
    public static final OGE DEFALT_MESSAGES_OGE = new OGE("local[\"woolpack.ee.MESSAGES\"]");
    private final OGE messagesOGE;
    private final boolean valueNotFoundIgnoreFlag;
    private final ValidatorExpression validatorExpression;

    public ValidatorBuilder(ValidatorExpression validatorExpression, OGE messagesOGE, boolean valueNotFoundIgnoreFlag) {
        validatorExpression.getClass();
        messagesOGE.getClass();
        this.validatorExpression = validatorExpression;
        this.messagesOGE = messagesOGE;
        this.valueNotFoundIgnoreFlag = valueNotFoundIgnoreFlag;
    }

    public ValidatorBuilder(ValidatorExpression validatorExpression) {
        this(validatorExpression, DEFALT_MESSAGES_OGE, false);
    }

    public OGE getOGE() {
        return this.messagesOGE;
    }

    public DomExpression getCheckExpression(final DomExpression trueExpression, final DomExpression falseExpression) {
        return new DomExpression(){

            public void interpret(DomContext domContext) {
                ValidatorContext validatorContext = new ValidatorContext();
                validatorContext.setId(domContext.getId());
                validatorContext.setInputMap(ValidatorConstants.convert(domContext.getInput()));
                Map tmpMap = domContext.getInput();
                try {
                    try {
                        domContext.setInput(validatorContext.getInputMap());
                        if (ValidatorBuilder.this.validatorExpression.interpret(validatorContext)) {
                            trueExpression.interpret(domContext);
                        } else {
                            ValidatorBuilder.this.messagesOGE.setValue(domContext, validatorContext.getMessageList());
                            falseExpression.interpret(domContext);
                        }
                    }
                    catch (RuntimeException e) {
                        throw new ValidatorRuntimeException(validatorContext, (Throwable)e);
                    }
                }
                finally {
                    domContext.setInput(tmpMap);
                }
            }
        };
    }

    public DomExpression getReplaceExpression() {
        return this.getResolveEmbeddingExpression(new EmbeddingResolveable(){

            @Override
            public void resolve(Map<String, Object> map) {
            }

            @Override
            public String resolve(Map<String, Object> map, String value) {
                return (String)map.get(value);
            }
        });
    }

    public DomExpression getResolveEmbeddingExpression(final EmbeddingResolveable resolver) {
        resolver.getClass();
        return new DomExpression(){

            public void interpret(DomContext context) {
                List messages = (List)ValidatorBuilder.this.messagesOGE.getValue(context);
                if (messages != null) {
                    int size = messages.size();
                    Map<String, Object> config = context.getConfig();
                    int i = 0;
                    while (i < size) {
                        String key = (String)messages.get(i);
                        String value = resolver.resolve(config, key);
                        if (value == null) {
                            if (!ValidatorBuilder.this.valueNotFoundIgnoreFlag) {
                                throw new NullPointerException("not found.");
                            }
                        } else {
                            messages.set(i, value);
                        }
                        ++i;
                    }
                }
            }
        };
    }
}

