/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.Collection;
import org.w3c.dom.Element;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.OGE;
import woolpack.utils.UtilsConstants;

public class EqualsAttrValue
implements DomExpression {
    private final String attrName;
    private final OGE valueOGE;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public EqualsAttrValue(String attrName, OGE valueOGE, DomExpression trueExpression) {
        this(attrName, valueOGE, trueExpression, DomConstants.NULL);
    }

    public EqualsAttrValue(String attrName, OGE valueOGE, DomExpression trueExpression, DomExpression falseExpression) {
        attrName.charAt(0);
        valueOGE.getClass();
        trueExpression.getClass();
        falseExpression.getClass();
        this.attrName = attrName;
        this.valueOGE = valueOGE;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public void interpret(DomContext context) {
        Object value = this.valueOGE.getValue(context);
        Collection collection = UtilsConstants.toCollection(value);
        String elementValue = ((Element)context.getNode()).getAttribute(this.attrName);
        boolean containsFlag = false;
        for (Object o : collection) {
            if (o == null || !o.toString().equals(elementValue)) continue;
            containsFlag = true;
            break;
        }
        if (containsFlag) {
            this.trueExpression.interpret(context);
        } else {
            this.falseExpression.interpret(context);
        }
    }
}

