! mpi_sp_module.F -*-f90-*-
! MPI Serial/Parallel module
! Time-stamp: <2007-09-18 13:20:51 takeshi>
! Author: Takeshi NISHIMATSU
!!
#if defined HAVE_CONFIG_H
#  include "config.h"
#endif

module mpi_sp_module
  implicit none
#ifdef MPI_PARALLEL
  include 'mpif.h'
  integer mpi_sp_my_rank
  integer mpi_sp_n_processor
  character (len=MPI_MAX_PROCESSOR_NAME) :: mpi_sp_my_hostname
#else
  integer, parameter :: mpi_sp_my_rank = 0
  integer, parameter :: mpi_sp_n_processor = 1
  integer, parameter :: MPI_COMM_WORLD = 0
contains
  subroutine MPI_Barrier(comm, i_error)
    implicit none
    integer, intent(in)  ::  comm
    integer, intent(out) ::  i_error
    i_error = comm*0   ! prevent compiler warning
  end subroutine MPI_Barrier
  !
  subroutine MPI_Abort(comm, errorcode, i_error)
    implicit none
    integer, intent(in)  ::  comm, errorcode
    integer, intent(out) ::  i_error
    i_error = comm * errorcode   ! prevent compiler warning
    stop
  end subroutine MPI_Abort
  !
  real*8 function MPI_Wtime()
    implicit none
    integer count, count_rate
    call system_clock(count, count_rate)
    MPI_Wtime = dble(count)/count_rate
  end function MPI_Wtime
#endif
end module mpi_sp_module
