static void convert_effect(tmdy_struct_ex_t *tmdy_struct, EffectList *);
static EffectList *push_effect(tmdy_struct_ex_t *tmdy_struct, EffectList *, int8, void *);
static void do_effect_list(tmdy_struct_ex_t *tmdy_struct, int32 *, int32, EffectList *);
static void free_effect_list(tmdy_struct_ex_t *tmdy_struct, EffectList *);


static void set_dry_signal(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);
static void mix_dry_signal(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);

/* channel by channel reverberation effect */
static void do_reverb(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void do_ch_reverb(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void set_ch_reverb(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
static void do_mono_reverb(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void init_reverb(tmdy_struct_ex_t *tmdy_struct, int32);
static void reverb_rc_event(tmdy_struct_ex_t *tmdy_struct, int, int32);
static void recompute_reverb_value(tmdy_struct_ex_t *tmdy_struct, int32);

/* channel by channel delay effect */
static void do_ch_delay(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void set_ch_delay(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
static void init_ch_delay(tmdy_struct_ex_t *tmdy_struct);

/* channel by channel chorus effect */
static void do_ch_chorus(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void set_ch_chorus(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
static void init_chorus_lfo(tmdy_struct_ex_t *tmdy_struct);
static void init_ch_chorus(tmdy_struct_ex_t *tmdy_struct);

/* channel by channel equalizer */
static void init_eq(tmdy_struct_ex_t *tmdy_struct);
static void set_ch_eq(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);
static void do_ch_eq(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
static void calc_lowshelf_coefs(tmdy_struct_ex_t *tmdy_struct, int32*,int32,FLOAT_T,int32);
static void calc_highshelf_coefs(tmdy_struct_ex_t *tmdy_struct, int32*,int32,FLOAT_T,int32);

/* insertion effect */
static void init_insertion_effect(tmdy_struct_ex_t *tmdy_struct);
static void do_insertion_effect(tmdy_struct_ex_t *tmdy_struct, int32*, int32);

/* lowpass filter for system effects */
static void do_lowpass_24db(tmdy_struct_ex_t *tmdy_struct, register int32*,int32,int32*,int32*);
static void calc_lowpass_coefs_24db(tmdy_struct_ex_t *tmdy_struct, int32*,int32,int16,int32);

static void free_effect_buffers(tmdy_struct_ex_t *tmdy_struct);

#define REVERB TMDY_REVERB
