
/**** global functions ****/
static void readmidi_read_init(tmdy_struct_ex_t *tmdy_struct);
static int32 readmidi_set_track(tmdy_struct_ex_t *tmdy_struct, int trackno, int rewindp);
static void readmidi_add_event(tmdy_struct_ex_t *tmdy_struct, MidiEvent *newev);
static void readmidi_add_ctl_event(tmdy_struct_ex_t *tmdy_struct, int32 at, int ch, int control, int val);
static int parse_sysex_event(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
static int parse_sysex_event_multi(tmdy_struct_ex_t *tmdy_struct, uint8 *data, int32 datalen, MidiEvent *ev_ret);
static int convert_midi_control_change(tmdy_struct_ex_t *tmdy_struct, int chn, int type, int val,
				       MidiEvent *ev_ret);
static char *readmidi_make_string_event(tmdy_struct_ex_t *tmdy_struct, int type, char *string, MidiEvent *ev,
					int cnv);
static MidiEvent *read_midi_file(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *mtf,
				 int32 *count, int32 *sp, char *file_name);
static struct midi_file_info *get_midi_file_info(tmdy_struct_ex_t *tmdy_struct, char *filename,int newp);
static struct midi_file_info *new_midi_file_info(tmdy_struct_ex_t *tmdy_struct, const char *filename);
static void free_all_midi_file_info(tmdy_struct_ex_t *tmdy_struct);
static int check_midi_file(tmdy_struct_ex_t *tmdy_struct, char *filename);
static char *get_midi_title(tmdy_struct_ex_t *tmdy_struct, char *filename);
static struct timidity_file *open_midi_file(tmdy_struct_ex_t *tmdy_struct, char *name,
					    int decompress, int noise_mode);
static int midi_file_save_as(tmdy_struct_ex_t *tmdy_struct, char *in_name, char *out_name);
static char *event2string(tmdy_struct_ex_t *tmdy_struct, int id);
static void change_system_mode(tmdy_struct_ex_t *tmdy_struct, int mode);
static int get_default_mapID(tmdy_struct_ex_t *tmdy_struct, int ch);
static int dump_current_timesig(tmdy_struct_ex_t *tmdy_struct, MidiEvent *codes, int maxlen);



static void recompute_delay_status(tmdy_struct_ex_t *tmdy_struct);
static void set_delay_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
static void recompute_chorus_status(tmdy_struct_ex_t *tmdy_struct);
static void set_chorus_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
static void recompute_reverb_status(tmdy_struct_ex_t *tmdy_struct);
static void set_reverb_macro(tmdy_struct_ex_t *tmdy_struct, int macro);
static void recompute_eq_status(tmdy_struct_ex_t *tmdy_struct);
static void set_insertion_effect_default_parameter(tmdy_struct_ex_t *tmdy_struct);
static void recompute_insertion_effect(tmdy_struct_ex_t *tmdy_struct);

static void recompute_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
static void free_userdrum(tmdy_struct_ex_t *tmdy_struct);

static void recompute_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
static void free_userinst(tmdy_struct_ex_t *tmdy_struct);

static void init_channel_layer(tmdy_struct_ex_t *tmdy_struct, int);
static void add_channel_layer(tmdy_struct_ex_t *tmdy_struct, int, int);
static void remove_channel_layer(tmdy_struct_ex_t *tmdy_struct, int);




/**** local functions ****/
static void init_delay_status(tmdy_struct_ex_t *tmdy_struct);
static void recompute_delay_status(tmdy_struct_ex_t *tmdy_struct);
static void set_delay_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

static void init_chorus_status(tmdy_struct_ex_t *tmdy_struct);
static void recompute_chorus_status(tmdy_struct_ex_t *tmdy_struct);
static void set_chorus_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

static void init_reverb_status(tmdy_struct_ex_t *tmdy_struct);
static void recompute_reverb_status(tmdy_struct_ex_t *tmdy_struct);
static void set_reverb_macro(tmdy_struct_ex_t *tmdy_struct, int macro);

static void init_eq_status(tmdy_struct_ex_t *tmdy_struct);
static void recompute_eq_status(tmdy_struct_ex_t *tmdy_struct);

static void init_insertion_effect_status(tmdy_struct_ex_t *tmdy_struct);
static void set_insertion_effect_default_parameter(tmdy_struct_ex_t *tmdy_struct);
static void recompute_insertion_effect(tmdy_struct_ex_t *tmdy_struct);


static void init_userdrum(tmdy_struct_ex_t *tmdy_struct);
UserDrumset *get_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
static void recompute_userdrum(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
static void recompute_userdrum_altassign(tmdy_struct_ex_t *tmdy_struct, int bank,int group);

static void init_userinst(tmdy_struct_ex_t *tmdy_struct);
UserInstrument *get_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
static void recompute_userinst(tmdy_struct_ex_t *tmdy_struct, int bank, int prog);
//static void recompute_userinst_altassign(int bank,int group);


/* rcp.c */
int read_rcp_file(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf, char *magic0, char *fn);
/* smfconv.c */
#ifdef SMFCONV
#ifdef __W32__

int is_midifile_filename(tmdy_struct_ex_t *tmdy_struct, char *filename);
int smfconv_w32(tmdy_struct_ex_t *tmdy_struct, struct timidity_file *tf,char *fn);

#endif /* __W32__ */
#endif /* SMFCONV */

/* mfi.c */
extern int read_mfi_file(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);
extern char *get_mfi_file_title(tmdy_struct_ex_t * tmdy_struct, struct timidity_file *tf);

#define RM TMDY_READMIDI
