/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    dummy_c.c
    dummy control mode -- no action, just prints out messages.
    */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include "tmdy_struct.h"
#include "timidity.h"
#include "common.h"
#include "output.h"
#include "controls.h"
#include "instrum.h"
#include "playmidi.h"
#include "readmidi.h"
#ifdef __W32__
#include "wrd.h"
#endif /* __W32__ */


static void ctl_pass_playing_list(tmdy_struct_ex_t * tmdy_struct, int n, char *args[]);
static int ctl_open(tmdy_struct_ex_t* tmdy_struct, int using_stdin, int using_stdout);
static void ctl_close(tmdy_struct_ex_t* tmdy_struct);
static int ctl_read(tmdy_struct_ex_t* tmdy_struct, int32 *valp);
static int cmsg(tmdy_struct_ex_t* tmdy_struct, int type, int verbosity_level, char *fmt, ...);
static void ctl_event(tmdy_struct_ex_t* tmdy_struct, CtlEvent *e);

/**********************************/
/* export the interface functions */

#define ctl dummy_control_mode

ControlMode ctl=
{
    "dummy interface", 'D',
    1,0,0,
    0,
    ctl_open,
    ctl_close,
    ctl_pass_playing_list,
    ctl_read,
    cmsg,
    ctl_event
};

static FILE *outfp;

static void ctl_pass_playing_list(tmdy_struct_ex_t * tmdy_struct, int n, char *args[]){
	while(ctl.opened==1){
#ifndef HAVE_SLEEP
		usleep((10) * 1000000);
#else
		sleep(10);
#endif
	}	
}

/*ARGSUSED*/
static int ctl_open(tmdy_struct_ex_t* tmdy_struct, int using_stdin, int using_stdout)
{
  if(using_stdout)
    outfp=stderr;
  else
    outfp=stdout;
  ctl.opened=1;
  return 0;
}

static void ctl_close(tmdy_struct_ex_t* tmdy_struct)
{
  fflush(outfp);
  ctl.opened=0;
}

/*ARGSUSED*/
static int ctl_read(tmdy_struct_ex_t* tmdy_struct, int32 *valp)
{
  return RC_NONE;
}

static int cmsg(tmdy_struct_ex_t* tmdy_struct, int type, int verbosity_level, char *fmt, ...)
{
  va_list ap;

  if ((type==CMSG_TEXT || type==CMSG_INFO || type==CMSG_WARNING) &&
      ctl.verbosity<verbosity_level)
    return 0;
  va_start(ap, fmt);
  if (!ctl.opened)
    {
      vfprintf(stderr, fmt, ap);
      fputs(NLS, stderr);
    }
  else
    {
      vfprintf(outfp, fmt, ap);
      fputs(NLS, outfp);
      fflush(outfp);
    }
  va_end(ap);
  return 0;
}

static void ctl_event(tmdy_struct_ex_t* tmdy_struct, CtlEvent *e)
{
    switch(e->type)
    {
    }
}

/*
 * interface_<id>_loader();
 */
ControlMode *interface_D_loader(void)
{
    return &ctl;
}
