<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
  method="text"
  encoding="UTF-8"/>
 
<xsl:template match="/"><xsl:apply-templates/></xsl:template>
 
<xsl:template match="document"><xsl:variable name="title" select="title/text()"/><xsl:value-of select="$title"/><xsl:apply-templates/></xsl:template>
 
<xsl:template match="title"></xsl:template>
 
<xsl:template match="paragraph"><xsl:apply-templates/></xsl:template>
 
<xsl:template match="anchor"><xsl:value-of select="text()"/></xsl:template>
 
<xsl:template match="unorderedList"><xsl:apply-templates/></xsl:template>
 
<xsl:template match="orderedList"><xsl:apply-templates/></xsl:template>
 
<xsl:template match="listItem"><xsl:variable name="parentElementName" select="local-name(..)"/><xsl:if test="$parentElementName = 'unorderedList'">* </xsl:if><xsl:if test="$parentElementName = 'orderedList'"><xsl:value-of select="position()"/>. </xsl:if><xsl:apply-templates/>
</xsl:template>
 
<xsl:template match="sectionTitle"><xsl:value-of select="text()"/>
</xsl:template>
 
<xsl:template match="definitionList"><xsl:apply-templates/></xsl:template>
 
<xsl:template match="definitionTerm">$ <xsl:value-of select="text()"/>
</xsl:template>
 
<xsl:template match="definitionDescription"><xsl:apply-templates/>
</xsl:template>
 
</xsl:transform>

