# Do not use 'package' statement.
# PackageManager must run in main-packages.

# use strict;use warnings; 

my $version='0.5.2';

-d 'plugins' or mkdir('plugins',0777) or die('can not mkdir plugins directory');

###
### Create link to pluginmgr
###

$main::inline_plugin{'a_pluginmgr'} = sub {
    &main::verb( qq(<a href="$main::me?a=pluginmgr">Plugin Manager</a>) );
};

###
### create plugin list
### 

local *DIR;
opendir(DIR,'plugins');
my @plugins =
    sort{ $a->{name} cmp $b->{name} } 
    map {
        +{ 
            name  => pack('h*',$_) ,
            hexnm => $_  ,
            key   => "pluginmgr__$_" ,
            path  => "plugins/$_" ,
        };
    }
    grep{ /^([0-9a-f][0-9a-f])+$/ }
    readdir(DIR) ;
closedir(DIR);

unless( $main::form{a} && $main::form{a} =~ /^pluginmgr/ ){
    foreach my $p ( grep( $main::config{$_->{key}} , @plugins) ){
        do $p->{path} ; $@ and die($@);
    }
}

###
### Plugin Uploader
###

$main::action_plugin{'pluginmgr_upload'} = sub{
    &main::ninsho;
    my $name=$main::form{'plugin.filename'};
    my $body=$main::form{'plugin'};
    local *FP;
    my $hexnm = unpack('h*',$name);
    open(FP,">plugins/$hexnm") or die;
        print FP $body;
    close(FP);
    if( $main::form{'enable'} ){
        $main::config{"pluginmgr__$hexnm"} = 1;
    }else{
        $main::config{"pluginmgr__$hexnm"} = 0;
    }
    &main::save_config();
    &main::transfer_url( "$main::me?a=pluginmgr" );
};

###
### Plugin Enable/Disabler
###

$main::action_plugin{'pluginmgr_permit'} = sub {
    &main::ninsho;
    foreach my $key (grep(/^pluginmgr__/,keys %::config)){
        delete $main::config{$key};
    }
    while( my ($key,$value)=each %::form ){
        $main::config{$key} = 1 if $key =~ /^pluginmgr__/;
    }
    &main::save_config;
    &main::transfer_url( "$main::me?a=pluginmgr" );
};

###
### Plugin Eraser
###
$main::action_plugin{'pluginmgr_erase'} = sub {
    &main::ninsho;
    my $fn=$main::form{target};
    $fn =~ /^([0-9a-f][0-9a-f])+$/ or die("!Invalied plugin-filename $fn!");
    -f "./plugins/$fn" or die('!Remove not exists plugin!');
    unlink "./plugins/$fn";
    &main::transfer_url( "$main::me?a=pluginmgr" );
};

###
### Plugin Manager Menu
###

$main::action_plugin{'pluginmgr'} = sub {
    unshift(@main::copyright,"<div>Plugin Manager $version</div>");
    &main::print_header( divclass=>'max' , title=>'Plugin Manager' );
    &main::putenc(<<HTML
<h1>Plugin Manager</h1>
<div class="day">
<h2>Enable/Disable Plugin</h2>
<div class="body">
<form name="plugin_form" action="%s" method="post" accept-charset="%s" >
HTML
    , $::postme , $::charset );
    foreach my $p (@plugins){
        &main::putenc('<input type="checkbox" name="%s" value="1"%s> %s<br>'
            , $p->{key} 
            , $main::config{$p->{key}} ? ' checked':''
            , $p->{name} );
    }
    foreach my $nm ( sort grep(/\.pl$/,&main::directory() )){
        &main::putenc('<input type="checkbox" checked disabled> %s (hand-installed)<br>'
            , $nm );
    }
    &main::putenc(<<HTML
<p>
Sign: <input type="password" name="password">
<input type="hidden" name="a" value="pluginmgr_permit">
<input type="submit" value="Submit">
</p>
</form>
</div><!-- body -->
</div><!-- day -->
<div class="day">
<h2>New plugin</h2>
<div class="body">
<form name="plugin_form" action="%s" enctype="multipart/form-data"
 method="post" accept-charset="%s" >
<p>Plugin file: <input type="file" name="plugin" size="48">
<input type="checkbox" name="enable" value="1" checked>enable?</p>
<p>Sign: <input type="password" name="password"
><input type="hidden" name="a" value="pluginmgr_upload"
><input type="submit" value="Submit">
</p>
</form>
</div><!-- body -->
</div><!-- day -->
<div class="day">
<h2>Erase unused Plugins</h2>
<div class="body">
<form action="%s" method="post" accept-charset="%s">
HTML
    , $main::me , $main::charset 
    , $main::me , $main::charset 
    );

    foreach my $p (@plugins){
        unless( $main::config{ $p->{key} } ){
            &main::putenc('<input type="radio" name="target" value="%s"> %s<br>'
                , $p->{hexnm}
                , $p->{name}
            );
        }
    }

    &main::putenc(<<HTML
<p>Sign: <input type="password" name="password"
><input type="hidden" name="a" value="pluginmgr_erase"
><input type="submit" value="Submit">
</p>
</form>
</div><!-- body -->
</div><!-- day -->
HTML
    );
    &main::print_copyright;
    &main::print_footer;
};

1;
