<?php
class ContactFormBB extends XCube_ActionFilter{
	var $field = array(
		'label' => null,
		'type' => 'text',
		'required' => false,
		'options' => array(),
		'id' => null,
		'default' => null,
	);	
    function preBlockFilter() {
        $this->mController->mRoot->mDelegateManager->add("MyTextSanitizer.XoopsCodePre",array(&$this,"BBCodePre"));
    }
    /*
     * Add Short code into Delegate BBCode 
     */
    function BBCodePre(&$patterns, &$replacements, $allowimage) {
        $patterns[] = '/\[contact-form\]/es';
        $replacements[] = "ContactFormBB::formStart();";
          	
        $patterns[] = '/\[contact-field (.*?)\/\]/es';
        $replacements[] = "ContactFormBB::contact_form_render_field('\\1');";

        $patterns[] = '/\[\/contact-form\]/es';
        $replacements[] = "ContactFormBB::formStop();";

        $patterns[] = '/>(\s*)((\015\012)|(\015)|(\012))/';
        $replacements[] = ">";
    }
    /*
     * Make Shrot code return strings
     */
    function formStart() {
    	$_SESSION['ContactFormBB']['redirect_url']=$_SERVER['REQUEST_URI'];
    	$ret = '<div id="ContactFormBB">';
    	$ret .= '<form action="' . XOOPS_URL . '/common/plugins/ContactFormBB/ContactFormBB.php" name="ContactFormBB" class="ContactFormBB" method="post" onsubmit="return xoopsFormValidate_ContactFormBB();">';
    	$ret .= "<table>";
        return $ret;
    }
    function formStop() {
		$ret = "</table>";	
    	$ret .= '<p style="text-align: center; padding: 5px;">';	//<input type="submit">
    	$ret .= '<input type="image" border="0" alt="" value="submit" src="'.XOOPS_URL.'/uploads/btn_submit.png"></p></form></div>';
    	return $ret;
    }
	function contact_form_render_field( $args='' ) {
		global $xoopsUser;
		// Short code parser start
    	$args = htmlspecialchars(stripslashes($args),ENT_QUOTES,_CHARSET);
		$args = preg_replace('/("|&amp;quot;|&quot;|#39;)/',"",$args);
		$query = explode(" ",$args);
		// Short code parser end
		$ret = "";
		$field = array();
		//var_dump($query);
		//echo "<hr>";
		foreach($query as $q){
			//var_dump($q);
			$param = explode("=",$q);
			//if($param[0]=="") break;
			if (preg_match('/"(.*?)"/',$param[1],$matches))
				$field[$param[0]] = $matches[1];
			else
				$field[$param[0]] = $param[1];
		}
		/*
		 * make view
		 */
		$field_id = isset($field['id']) ? $field['id'] : $field['label'];
		if ( isset($_POST[ $field_id ]) ) {
			$field_value = stripslashes( $_POST[ $field_id ] );
		} elseif ( isset($_SESSION['ContactFormBB'][$field_id]['value']) ) {
			$field_value = $_SESSION['ContactFormBB'][$field_id]['value'];
		} elseif ( $xoopsUser ) {
			// Special defaults for logged-in users
			if ( $field['type'] == 'email' )
				$field_value = $xoopsUser->getvar('email');
			elseif ( $field['type'] == 'name' )
				$field_value = $xoopsUser->getvar('name');
			elseif ( $field['type'] == 'url' )
				$field_value = $xoopsUser->getvar('url');
			else
				$field_value = $field['default'];
		} else {
			$field_value = $field['default'];
		}
		foreach($field as $key=>$val){
			$_SESSION['ContactFormBB'][$field_id][$key]=$val;
		}
		if (isset($field['options'])){
			$options = explode(",",$field['options']);
		}
		if (isset($field['options2'])){
			$options2 = explode(",",$field['options2']);
		}
		$form_error = $title = $input = '';	//	contact_form_is_error($field_id) ? ' form-error' : '';
		$require = ( $field['required'] ? '&nbsp;<span class="red">'. "ɬ" . '</span>' : '' );
		if ( $field['type'] == 'email' ) {
			$title = "<label for='".$field_id."' class='grunion-field-label ".$field['type'] . $form_error . "'>" .  $field['label'] . $require . "</label>";
			$input = "<input type='text' name='".$field_id."' id='".$field_id."' value='".$field_value."' class='".$field['type']."'/>";
		}elseif ( $field['type'] == 'phone' ) {
			$title = "<label for='".$field_id."' class='grunion-field-label ".$field['type'] . $form_error . "'>" .  $field['label'] . $require . "</label>";
			$input = "<input type='text' name='".$field_id."_city' id='".$field_id."' value='".$field_value."' class='".$field['type']."' size='4' maxlength='4' />";
			$input .= "&nbsp;-&nbsp;<input type='text' name='".$field_id."_area' id='".$field_id."' value='".$field_value."' class='".$field['type']."' size='4' maxlength='4' />";
			$input .= "&nbsp;-&nbsp;<input type='text' name='".$field_id."_number' id='".$field_id."' value='".$field_value."' class='".$field['type']."' size='4' maxlength='4' />";
		} elseif ( $field['type'] == 'textarea' ) {
			$title= "<label for='".$field_id."' class='".$field['type'] . $form_error . "'>" .  $field['label'] . $require . "</label>";
			$input = "<textarea name='".$field_id."' id='contact-form-comment' rows='5' cols='43'>".$field_value."</textarea>";
		} elseif ( $field['type'] == 'radio' ) {
			$title = "<label class='". $form_error . "'>" .  $field['label'] . $require . "</label>";
			foreach ( $options as $option ) {
				$input .= "<input type='radio' name='".$field_id."' value='".$option."' class='".$field['type']."' ".( $option == $field_value ? "checked='checked' " : "")." />";
	 			$input .= "<label class='".$field['type'] . $form_error . "'>".  $option . "</label><br />";
			}
		} elseif ( $field['type'] == 'checkbox' ) {
			$title = "<label class='".$field['type'] . $form_error . "'>";
			$title .= $field['label'] . $require . "</label>";
			$i=0;
			foreach ( $options as $option ) {
				if ( $i>0 && $i % 3 ==0 ) $input .= "<br />";
				$input .= "<input type='checkbox' name='".$field_id."' value='".('Yes')
				."' class='".$field['type']."' ".( $field_value ? "checked='checked' " : "")." />&nbsp;".$option."&nbsp;";
				$i++;
			}
		} elseif ( $field['type'] == 'select' ) {
			$title = "<label for='".$field_id."' class='".$field['type'] . $form_error . "'>" .  $field['label'] . $require . "</label>";
			$input = "<select name='".$field_id."' id='".$field_id."' value='".$field_value."' class='".$field['type']."'/><br />";
			foreach ( $options as $option ) {
				$input .= "<option".( $option == $field_value ? " selected='selected'" : "").">"
				.  $option ."</option>";
			}
			$input .= "</select>";
			if (isset($field['options2'])){
				$input .= "<select name='".$field_id."2' id='".$field_id."2' value='".$field_value."' class='".$field['type']."'/><br />";
				foreach ( $options2 as $option ) {
					$input .= "<option".( $option == $field_value ? " selected='selected'" : "").">"
					.  $option ."</option>";
				}
				$input .= "</select>";
			}
		} else {
			// default: text field
			// note that any unknown types will produce a text input, so we can use arbitrary type names to handle
			// input fields like name, email, url that require special validation or handling at POST
			if (isset($field['size'])){
				$size = " size='" . intval($field['size']) . "'";
			}
			$title = "<label for='".$field_id."' class='".$field['type'] . $form_error . "'>" .  $field['label'] . $require . "</label>";
			$input = "<input type='text' name='".$field_id."' id='".$field_id."' value='".$field_value."' class='".$field['type']."'". $size. " />";
		}
		$ret = '<tr><th>' . $title . "</th><td>" . $input . '</td></tr>';
		$_SESSION['ContactFormBB']['field_id']++;
		return $ret;
	}
}
?>