/*  NDKmol - Molecular Viewer on Android NDK

     (C) Copyright 2011, biochem_fan

     This file is part of NDKmol.

     NDKmol is free software: you can redistribute it and/or modify
     it under the terms of the GNU Lesser General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <Atom.h>
#include <cmath>

Atom::Atom() {
	ss = "c";
	color.setRGB(0.8f, 0.8f, 0.8f, 1);
	valid = false;
}

bool Atom::isConnected(Atom &atom) {
	if (bonds.count(atom.serial) > 0) return true;

	float distSquared = (x - atom.x) * (x - atom.x) + (y - atom.y) * (y - atom.y) + (z - atom.z) * (z - atom.z);
	if (distSquared > 2.78 || std::isnan(distSquared)) return false;
	if (distSquared < 0.1) {
		return false;
	}
	//		Log.d("isConnected", "bond between " + serial + " and " + atom.serial + ", dist^2 = " + distSquared);
	return true;
}
