/*
 * Copyright 2011 IoriAYANE
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.xii.relog.customlibrary.widget;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import jp.sfjp.webglmol.NDKmol.R;
import jp.xii.relog.customlibrary.Utility;

public class FileListView extends ViewGroup 
	implements AdapterView.OnItemClickListener
			, View.OnClickListener{

	
	//????
	public final static String STR_ATTR_SELECT_DIR = "select_dir";		//???????????
	public final static String STR_ATTR_DEFAULT_DIR = "default_dir";	//????????????
	public final static String STR_ATTR_DISPATCH_BACK_KEY = "dispatch_back";	//????????????
	
	private View _mainView = null;
	
	private boolean _isSelectDir = false;			//???????????
	private File _currentDir = null;				//??????????????
	private ArrayList<File> _currentDirFileList = null;		//??????????????????????
	private Stack<File> _historyFileList = null;	//???????????????
	private boolean _isDispatchBackKey = true;		//????????????
	
	private onFileListListener _listener = null;	//?????

	
	/**
	 * ???????????
	 * @param _isSelectDir the _isSelectDir to set
	 * ?????????
	 */
	private void setIsSelectDir(boolean _isSelectDir) {
		this._isSelectDir = _isSelectDir;
	}
	/**
	 * ???????????
	 * @return the _isSelectDir
	 */
	public boolean isSelectDir() {
		return _isSelectDir;
	}


	/**
	 * ??????????????
	 * @param _currentDir the _currentDir to set
	 */
	public void setCurrentDirectory(File _currentDir) {
		this._currentDir = _currentDir;
	}
	/**
	 * ??????????????
	 * @return the _currentDir
	 */
	public File getCurrentDirectory() {
		if(_currentDir == null){
			_currentDir = new File(Utility.getSdcardPath());
		}
		return _currentDir;
	}
	
	/**
	 * ??????????????????????
	 * @return
	 */
	public ArrayList<File> getCurrentDirFileList() {
		if(_currentDirFileList == null){
			_currentDirFileList = new ArrayList<File>();
		}
		return _currentDirFileList;
	}

	/**
	 * ???????????????
	 * @return the _historyFileList
	 */
	public Stack<File> getHistoryFileList() {
		if(_historyFileList == null){
			_historyFileList = new Stack<File>();
		}
		return _historyFileList;
	}

	
	/**
	 * ????????????
	 * @param _isDispatchBackKey the _isDispatchBackKey to set
	 */
	public void setIsDispatchBackKey(boolean _isDispatchBackKey) {
		this._isDispatchBackKey = _isDispatchBackKey;
	}
	/**
	 * ????????????
	 * @return the _isDispatchBackKey
	 */
	public boolean isDispatchBackKey() {
		return _isDispatchBackKey;
	}
	
	/**
	 * ?????
	 * @param _listener the _listener to set
	 */
	public void setOnFileListListener(onFileListListener _listener) {
		this._listener = _listener;
	}
	/**
	 * ?????
	 * @return the _listener
	 */
	public onFileListListener getOnFileListListener() {
		return _listener;
	}
	
	
	/**
	 * ?????????77
	 * @param context
	 * @param is_select_dir
	 */
	public FileListView(Context context, File default_dir, boolean is_select_dir){
		super(context);
		setCurrentDirectory(default_dir);
		setIsSelectDir(is_select_dir);
		init(null);
	}
	
	/**
	 * ?????????
	 * @param context
	 * @param attrs
	 */
	public FileListView(Context context, AttributeSet attrs) {
		super(context, attrs);
	
		init(attrs);
	}
	
	/**
	 * ?????
	 * @param attrs
	 */
	private void init(AttributeSet attrs){
		String temp = null;

		if(attrs == null){
		}else{
			//???????????
			setIsSelectDir(attrs.getAttributeBooleanValue(null, STR_ATTR_SELECT_DIR, false));
			//????????????
			temp = attrs.getAttributeValue(null, STR_ATTR_DEFAULT_DIR);
			if(temp != null){
				setCurrentDirectory(new File(temp));
			}else{
				//?????????icroSD
				setCurrentDirectory(new File(Utility.getSdcardPath()));
			}
			//????????????
			setIsDispatchBackKey(attrs.getAttributeBooleanValue(null, STR_ATTR_DISPATCH_BACK_KEY, true));
		}

	    //inflater????xml??????????iew???????
	    LayoutInflater inflater = (LayoutInflater)getContext()
	                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	    int id = 0;
	    if(isSelectDir()){
	    	id = R.layout.file_list_view_dir;
	    }else{
	    	id = R.layout.file_list_view;
	    }
	    _mainView = inflater.inflate(id, null);

	    //???????????????
	    Button button = (Button)_mainView.findViewById(R.id.FileSelectListOK_Button);
	    if(button != null){
		    button.setOnClickListener(this);
	    }
	    //????????????????
		ListView list = (ListView)_mainView.findViewById(R.id.FileList_ListView);
		if(list != null){
			list.setOnItemClickListener(this);
		}
		
		//????
	    viewFiles(getCurrentDirectory());
	}


	/**
	 * ????????
	 */
	@Override
	protected void onLayout(boolean changed, int left, int top, int right,
	        int bottom) {
	 
	    ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(
	                ViewGroup.LayoutParams.WRAP_CONTENT
	                , ViewGroup.LayoutParams.WRAP_CONTENT);
	     
	    addViewInLayout(_mainView, -1, lp);
	 
	    //??????????????????????
	    _mainView.layout(0, 0, _mainView.getMeasuredWidth(), _mainView.getMeasuredHeight());
	 
	}
	
	/**
	 * ?????
	 */
	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
	    //???????????????????
	    _mainView.measure(widthMeasureSpec, heightMeasureSpec);

		int spec_width = MeasureSpec.getSize(widthMeasureSpec);
		int spec_height = _mainView.getMeasuredHeight();

		//???設?
		setMeasuredDimension(spec_width, spec_height);
	}

	/**
	 * ???????
	 */
	@Override
	public boolean dispatchKeyEvent(KeyEvent event) {
		boolean ret = false;
		if(event.getKeyCode() == KeyEvent.KEYCODE_BACK){
			if(!isDispatchBackKey()){
				//???????
			}else if(event.getAction() == KeyEvent.ACTION_DOWN){
				//????????????
				try{
					File dir = getHistoryFileList().pop();
					dir = getHistoryFileList().pop();
					ret = viewFiles(dir);
				}catch(Exception e){
				}
			}
		}
		if(ret){
			return ret;
		}else{
			return super.dispatchKeyEvent(event);
		}
	}
	
	/**
	 * ?????????????
	 * @param path
	 */
	private boolean viewFiles(File dir){
		boolean ret = false;
		ListView list = (ListView)_mainView.findViewById(R.id.FileList_ListView);
		if(dir == null || list == null){
		}else if(!dir.canRead()){
			//?????
		}else{
			//???????
			ArrayAdapter<String> adapter = new ArrayAdapter<String>(getContext()
					, android.R.layout.simple_list_item_1);

			File[] file_lists = dir.listFiles();

			//?????
			getCurrentDirFileList().clear();
			//????????????
			setCurrentDirectory(dir);
			viewCurrentDirectory(dir);

			if(file_lists == null){
			}else{
				//追?
				for (File file : file_lists) {
					if(file.isDirectory()){
						//??????????????
						adapter.add(file.getName() + "/");
						getCurrentDirFileList().add(file);
					}else{
						//?????????
						if(isSelectDir()){
							//??????????????????????????
						}else{
							adapter.add(file.getName());
							getCurrentDirFileList().add(file);
						}
					}
				}
			}
			//空???
			if(adapter.getCount() == 0){
				adapter.add(getContext().getString(R.string.file_list_empty));
			}
			//履?????
			getHistoryFileList().push(dir);

			//????????
			list.setAdapter(adapter);
			
			ret = true;
		}
		return ret;
	}

	/**
	 * ???????????
	 * @param dir
	 */
	private void viewCurrentDirectory(File dir){
		TextView text = (TextView)_mainView.findViewById(R.id.FileListCurrentPath_TextView);
		if(dir == null || text == null){
		}else{
			text.setText(dir.getAbsolutePath());
		}
	}
	
	/**
	 * ??????????
	 */

	public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
		
		if(getCurrentDirFileList() == null){
		}else if(getCurrentDirFileList().size() <= position){
		}else{
			File file = getCurrentDirFileList().get(position);
			
			if(file.isDirectory()){
				//???????????????
				if(!viewFiles(file)){
					file = null;	//失???ull???????
				}
				if(getOnFileListListener() != null){
					getOnFileListListener().onChangeDirectory(file);
				}
			}else{
				//??????????????????????
				if(getOnFileListListener() != null){
					getOnFileListListener().onSelectFile(file);
				}
			}
		}
	}
	
	
	/**
	 * ??????????
	 */

	public void onClick(View v) {
		switch(v.getId()){
		case R.id.FileSelectListOK_Button:
			//?????????????????????
			if(getOnFileListListener() != null){
				getOnFileListListener().onSelectDirectory(getCurrentDirectory());
			}
			break;
		default:
			break;
		}
	}
	

	/**
	 * ????????????????????????????
	 * @author Iori
	 *
	 */
	public interface onFileListListener{
		public void onSelectFile(File file);
		public void onSelectDirectory(File file);
		public void onChangeDirectory(File file);
	}

}
