package test.org.itscool.commons.dao3;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.BaseDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.weber.testcase.WeberDbTestCase;

public class DeleteBeanDaoTest extends WeberDbTestCase{
    public void setUp(){
        this.clearTables();
        this.initTables("test/org/itscool/commons/dao3/test-db-data.xml");
    }
    
    public void testInsert(){
        DeleteBean company = new DeleteBean();
        company.setId(10);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DeleteBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            int insertCount = dao.insert(crt, company);
            assertEquals("insert count", 1, insertCount);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
            TransactionUtil.commitTransaction();
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
    public void testLogicalDelete(){
        DeleteBean company = new DeleteBean();
        company.setId(20);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DeleteBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            int insertCount = dao.insert(crt, company);
            assertEquals("delete count", 1, insertCount);
            int deleteCount = dao.delete(crt);
            assertEquals("delete count", 1, deleteCount);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
            TransactionUtil.commitTransaction();
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
    }
    
    public void testLogicalDelete2(){
        DeleteBean company = new DeleteBean();
        company.setId(30);
        company.setName("hoge com");
        
        BaseDao dao = new BaseDao();
        Criteria crt = new Criteria(DeleteBean.class);
        Transaction trn = TransactionUtil.getTransaction();
        
        try{
            int insertCount = dao.insert(crt, company);
            assertEquals("delete count", 1, insertCount);
            
            List list = dao.select(crt);
            assertEquals("select count(before delete)", 1, list.size());
            
            int deleteCount = dao.delete(crt);
            assertEquals("delete count", 1, deleteCount);
            assertEquals(Transaction.PLEASE_COMMIT,trn.getTranStatus());
            TransactionUtil.commitTransaction();
            
            list = dao.select(crt);
            assertEquals("select count(after delete)", 0, list.size());
            
        }catch( Exception e ){
            fail(e.getMessage());
        }finally{
            TransactionUtil.returnTransaction();
        }
        
    }
    
}
