package test.org.itscool.commons.dao.criteria;

import junit.framework.TestCase;
import org.itscool.commons.dao.*;

/**
 * 쐬: 2005/06/22
 * @author kanoum
 */
public class CustomerCriteria1Test extends TestCase{
    public CustomerCriteria1Test(String name){
        super(name);
    }
    
    public void testSelect1(){
        Criteria crt = new Criteria(Customer1.class);
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelect1() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOverBig(){
        Criteria crt = new Criteria(Customer1.class);
        crt.overbig("companyId", "123");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.COMPANY_ID >= 123").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectOverBig() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOverSmall(){
        Criteria crt = new Criteria(Customer1.class);
        crt.oversmall("companyId", "123");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.COMPANY_ID <= 123").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectOverSmall() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectMoreSmall(){
        Criteria crt = new Criteria(Customer1.class);
        crt.moresmall("id", "123");
        crt.and();
        crt.eq("name", "Y");
        //System.out.println("------------------------------");
        //System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID < 123").append(line);
        sb.append("    AND CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectMoreSmall() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectOr(){
        Criteria crt = new Criteria(Customer1.class);
        crt.eq("id", "123");
        crt.or();
        crt.eq("name", "Y");
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID = 123").append(line);
        sb.append("    OR CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectOr() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectNeq(){
        Criteria crt = new Criteria(Customer1.class);
        crt.neq("id", "123");
        crt.or();
        crt.neq("name", "Y");
//        System.out.println("------------------------------");
//        System.out.println(crt.toSelectString());
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID != 123").append(line);
        sb.append("    OR CUSTOMER.NAME != 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectNeq() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
    
    public void testSelectMoreBig(){
        Customer1 c = new Customer1();
        Criteria crt = new Criteria(Customer1.class);
        crt.morebig("id", "123");
        crt.and();
        crt.eq("name", "Y");
//        System.out.println("------------------------------");
//        System.out.println(crt.toUpdateString(c));
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(line);
        sb.append("    CUSTOMER.NAME as CUSTOMER_NAME,").append(line);
        sb.append("    CUSTOMER.POST_ID as CUSTOMER_POST_ID,").append(line);
        sb.append("    CUSTOMER.COMPANY_ID as CUSTOMER_COMPANY_ID,").append(line);
        sb.append("    CUSTOMER.ID as CUSTOMER_ID,").append(line);
        sb.append("    CUSTOMER.USER_ID as CUSTOMER_USER_ID,").append(line);
        
        sb.append("    POST.ID as POST_ID,").append(line);
        sb.append("    POST.NAME as POST_NAME,").append(line);
        sb.append("    COMPANY.ID as COMPANY_ID,").append(line);
        sb.append("    COMPANY.NAME as COMPANY_NAME,").append(line);
        
        sb.append("    USER.PASSWORD as USER_PASSWORD,").append(line);
        sb.append("    USER.ID as USER_ID,").append(line);
        sb.append("    USER.ROLE_ID as USER_ROLE_ID,").append(line);
        sb.append("    USER.NAME as USER_NAME").append(line);
        
        sb.append("FROM").append(line);
        sb.append("    CUSTOMER,").append(line);
        sb.append("    POST,").append(line);
        sb.append("    COMPANY,").append(line);
        sb.append("    USER").append(line);
        
        sb.append("WHERE").append(line);
        sb.append("    CUSTOMER.ID > 123").append(line);
        sb.append("    AND CUSTOMER.NAME = 'Y'").append(line);
        sb.append("    AND POST.ID = CUSTOMER.POST_ID").append(line);
        sb.append("    AND COMPANY.ID = CUSTOMER.COMPANY_ID").append(line);
        sb.append("    AND USER.ID = CUSTOMER.USER_ID");
        if(!sb.toString().equals(crt.toSelectString())){
            System.out.println("** testSelectMoreBig() ** ");
            System.out.println("test->"+sb.toString());
            System.out.println("result->"+crt.toSelectString());
        }
        assertEquals(sb.toString(), crt.toSelectString());
    }
}
