/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.ElementList;
import org.itscool.commons.util.TagUtil;
import org.itscool.stylist.el.LayoutRegex;

public class ServletTagUtil
extends TagUtil {
    public static Object findObject(ServletContext servletContext, HttpServletRequest req, String name, String scope) {
        Object obj = ServletTagUtil.lookup(servletContext, req, name, scope);
        return obj;
    }

    public static Object findProperty(ServletContext servletContext, HttpServletRequest req, String name, String property, String scope) {
        Object pObj = null;
        Object obj = null;
        if (name != null && name.length() != 0) {
            obj = ServletTagUtil.lookup(servletContext, req, name, scope);
        }
        if (obj != null && property != null) {
            pObj = obj instanceof GeneralForm ? ((GeneralForm)obj).getParameter(property) : (obj instanceof Map ? ((Map)obj).get(property) : (obj instanceof Hashtable ? ((Hashtable)obj).get(property) : BeanUtil.getProperty(obj, property)));
        } else if (obj == null && property != null) {
            pObj = ServletTagUtil.lookup(servletContext, req, property, scope);
        } else if (obj != null && property == null) {
            pObj = obj;
        }
        if (pObj == null) {
            pObj = new String("");
        }
        return pObj;
    }

    public static String findScope(ServletContext servletContext, HttpServletRequest req, String name) {
        Object obj = null;
        obj = req.getAttribute(name);
        if (obj != null) {
            return "request";
        }
        obj = req.getSession().getAttribute(name);
        if (obj != null) {
            return "session";
        }
        obj = servletContext.getAttribute(name);
        if (obj != null) {
            return "application";
        }
        return null;
    }

    protected static Object lookup(ServletContext servletContext, HttpServletRequest req, String name, String scope) {
        Object obj = null;
        if (scope == null) {
            obj = ServletTagUtil.lookup(servletContext, req, name);
            return obj;
        }
        if (scope.equals("application")) {
            obj = servletContext.getAttribute(name);
        } else if (scope.equals("session")) {
            obj = req.getSession().getAttribute(name);
        } else if (scope.equals("request")) {
            obj = req.getAttribute(name);
        }
        return obj;
    }

    protected static Object lookup(ServletContext servletContext, HttpServletRequest req, String name) {
        Object obj = null;
        obj = req.getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = req.getSession().getAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = servletContext.getAttribute(name);
        if (obj != null) {
            return obj;
        }
        return obj;
    }

    public static String createQueryString(ServletContext servletContext, HttpServletRequest req, String properties, String scope) {
        if (properties == null || properties.length() == 0) {
            return "";
        }
        StringTokenizer dataSt = new StringTokenizer(properties, ",");
        StringBuffer sb = new StringBuffer("");
        if (dataSt.hasMoreTokens()) {
            sb.append("?");
        }
        while (dataSt.hasMoreTokens()) {
            String data = dataSt.nextToken().trim();
            StringTokenizer propertySt = new StringTokenizer(data, ":");
            String name = propertySt.nextToken();
            if (name == null) {
                throw new RuntimeException("name is null query=" + properties);
            }
            name = name.trim();
            String property = null;
            if (propertySt.hasMoreTokens()) {
                property = propertySt.nextToken();
            }
            String htmlName = null;
            if (propertySt.hasMoreTokens()) {
                htmlName = propertySt.nextToken().trim();
            }
            Object value = null;
            if (property == null) {
                value = ServletTagUtil.findObject(servletContext, req, name, scope);
            } else {
                property = property.trim();
                value = ServletTagUtil.findProperty(servletContext, req, name, property, scope);
            }
            if (htmlName != null) {
                sb.append(htmlName).append("=");
            } else if (property == null) {
                sb.append(name).append("=");
            } else {
                sb.append(property).append("=");
            }
            if (value != null) {
                sb.append(value.toString());
            }
            if (!dataSt.hasMoreTokens()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static Object findValue(ServletContext servletContext, HttpServletRequest req, String value, String scope) {
        if (value == null) {
            return "";
        }
        if (value.length() < 3) {
            return value;
        }
        if (value.indexOf("${") >= 0) {
            LayoutRegex regex = new LayoutRegex(servletContext, req);
            String obj = regex.replaceEl(value);
            return obj;
        }
        return value;
    }

    public static ElementList parseEl(String value) {
        ElementList elems = new ElementList();
        String property = null;
        if (value == null || value.equals("")) {
            return elems;
        }
        if (value.length() < 3) {
            return elems;
        }
        int startIndex = value.indexOf("${");
        int lastIndex = value.lastIndexOf("}");
        if (startIndex < 0 || lastIndex < 0) {
            return elems;
        }
        property = value.substring(startIndex + 2, lastIndex);
        if (property != null && property.length() > 0) {
            property = property.trim();
        }
        StringTokenizer propertySt = new StringTokenizer(property, ".");
        while (propertySt.hasMoreTokens()) {
            property = propertySt.nextToken().trim();
            property = property.substring(0, property.length());
            elems.add(property);
        }
        return elems;
    }
}

