/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.itscool.commons.document.DocumentBean;
import org.itscool.commons.document.DocumentBeanParser;
import org.itscool.commons.document.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BeanToXmlDocument
extends XmlDocument {
    public BeanToXmlDocument(String rootName) throws Exception {
        super(rootName);
    }

    public BeanToXmlDocument(Document document) throws Exception {
        super(document);
    }

    public void addElement(Object bean, String elementName) throws Exception {
        Class<?> clazz = bean.getClass();
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
        if (elementName != null) {
            pBean.setName(elementName);
        }
        this.addElement(pBean);
    }

    public void addElement(Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
        this.addElement(pBean);
    }

    public void addElement(Object[] objects, String elementName) throws Exception {
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        for (int i = 0; i < objects.length; ++i) {
            Object bean = objects[i];
            if (bean == null) continue;
            Class<?> clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        this.addElement(pParentBean);
    }

    public void addElement(Object[] objects) throws Exception {
        this.addElement(objects, "array");
    }

    public void addElement(List list, String elementName) throws Exception {
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        for (int i = 0; i < list.size(); ++i) {
            Object bean = list.get(i);
            if (bean == null) continue;
            Class<?> clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        this.addElement(pParentBean);
    }

    public void addElement(List list) throws Exception {
        this.addElement(list, "list");
    }

    public void addElement(Map map, String elementName) throws Exception {
        DocumentBean pParentBean = new DocumentBean();
        pParentBean.setName(elementName);
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object bean = map.get(key);
            if (bean == null) continue;
            Class<?> clazz = bean.getClass();
            DocumentBean pBean = DocumentBeanParser.parseBean(bean, clazz, this);
            pParentBean.add(pBean);
        }
        this.addElement(pParentBean);
    }

    public void addElement(Map map) throws Exception {
        this.addElement(map, "map");
    }

    protected void addElement(DocumentBean pBean) throws Exception {
        Element root = this.document.getDocumentElement();
        Element beanElement = this.document.createElement(pBean.getName());
        int size = pBean.size();
        for (int i = 0; i < size; ++i) {
            DocumentBean child = (DocumentBean)pBean.get(i);
            String name = child.getName();
            String value = (String)child.getValue();
            Element element = this.document.createElement(name);
            if (value != null) {
                element.appendChild(this.document.createTextNode(value));
            }
            this.addChild(child, element);
            beanElement.appendChild(element);
        }
        root.appendChild(beanElement);
    }

    protected void addChild(DocumentBean pBean, Element element) throws Exception {
        int size = pBean.size();
        for (int i = 0; i < size; ++i) {
            DocumentBean child = (DocumentBean)pBean.get(i);
            String name = child.getName();
            String value = (String)child.getValue();
            Element childElement = this.document.createElement(name);
            if (value != null) {
                childElement.appendChild(this.document.createTextNode(value));
            }
            if (child.size() > 0) {
                this.addChild(child, childElement);
            }
            element.appendChild(childElement);
        }
    }
}

