/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;

public class RecordMapOneToManyFactory
extends RecordMapFactory {
    public static final String ONE_TO_MANY = "ONE_TO_MANY_CLASS_";
    public static final String ONE_TO_MANY_COLUM = "ONE_TO_MANY_COLUM_";

    public static HashMap createOneToManyRecordMaps(String className) {
        try {
            Class<?> entity = Class.forName(className);
            return RecordMapOneToManyFactory.createOneToManyRecordMaps(entity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap createOneToManyRecordMaps(Class entity) {
        HashMap fkRecordMaps = new HashMap();
        fkRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(entity, fkRecordMaps);
        return fkRecordMaps;
    }

    public static synchronized HashMap createOneToManyRecordMaps(Class entity, HashMap fkRecordMaps) {
        Class superClazz = entity.getSuperclass();
        if (superClazz != null) {
            fkRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(superClazz, fkRecordMaps);
        }
        String clazzName = entity.getName();
        Object obj = BeanUtil.createInstance(clazzName);
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            try {
                String staticName = field.getName();
                int index = staticName.indexOf(ONE_TO_MANY);
                if (modifier != 25 || index != 0) continue;
                String propertyName = staticName.substring(ONE_TO_MANY.length(), staticName.length());
                String propertyType = RecordMapOneToManyFactory.getStringValue(entity, obj, ONE_TO_MANY + propertyName);
                RecordMap recordMap = RecordMapFactory.createRecordMap(propertyType);
                RecordMapOneToManyFactory.setForignKey(recordMap, entity, recordMap.getTableName(), ONE_TO_MANY_COLUM + propertyName + "_");
                if (propertyType == null) continue;
                recordMap.setClassName(propertyType);
                fkRecordMaps.put(propertyName, recordMap);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return fkRecordMaps;
    }

    protected static String getStringValue(Class entity, Object obj, String fieldName) throws Exception {
        Field field = entity.getField(fieldName);
        String stringValue = (String)field.get(obj);
        return stringValue;
    }

    private static void setForignKey(RecordMap recordMap, Class entity, String tableName, String columHeaderName) {
        Object obj = BeanUtil.createInstance(entity.getName());
        recordMap.setClassName(entity.getName());
        recordMap.setTableName(tableName);
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            try {
                String staticName = field.getName();
                int index = staticName.indexOf(columHeaderName);
                if (modifier != 25 || index != 0) continue;
                String fieldName = (String)field.get(obj);
                fieldName = fieldName.toUpperCase();
                String propertyName = staticName.substring(columHeaderName.length(), staticName.length());
                FieldMap fieldMap = recordMap.getFieldByFieldName(fieldName);
                fieldMap.setFkPropertyName(propertyName);
                fieldMap.setForignKey(true);
                continue;
            }
            catch (IllegalAccessException e) {
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" + "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
            catch (NullPointerException e) {
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" + "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
        }
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                String propertyName = fieldMap.getPropertyName();
                Field field = BeanUtil.getField(entity, propertyName);
                if (field == null) continue;
                String type = field.getType().getName();
                fieldMap.setType(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

