/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.commons.dao.AutoNumberDao;
import org.itscool.commons.dao.Criteria;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.LockVersionException;
import org.itscool.commons.dao.RecordMap;

public class BaseDao {
    protected Transaction transaction = TransactionUtil.getTransaction();

    public BaseDao() {
        if (this.transaction == null) {
            throw new RuntimeException(BaseDao.class.getName() + " transaction is null.");
        }
    }

    public int getCount(String tableName) {
        String sql = "SELECT COUNT(*) AS DATA_NUM FROM " + tableName;
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(sql);
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        return dataNum;
    }

    public int getCount(Criteria crt) {
        Transaction trn = TransactionUtil.getTransaction();
        Records records = trn.select(crt.toCountString());
        Record record = (Record)records.get(0);
        int dataNum = record.getInt("DATA_NUM");
        return dataNum;
    }

    public void setTransaction(Transaction trn) {
        this.transaction = trn;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int insert(Criteria crt, Object bean) throws TransactionException {
        String sql = crt.toInsertString(bean);
        return this.transaction.execute(sql);
    }

    public int update(Criteria crt, Object bean) throws TransactionException {
        String sql = crt.toUpdateString(bean);
        int recNum = this.transaction.execute(sql);
        if (recNum > 0) {
            return recNum;
        }
        String lckSql = crt.toSelectLockVersionString();
        if (lckSql == null) {
            return recNum;
        }
        Record lckRec = this.transaction.selectOne(lckSql);
        if (lckRec == null) {
            return recNum;
        }
        int dbVersion = lckRec.getInt("LOCK_VERSION");
        Object obj = crt.getLockVersion(bean);
        if (obj instanceof Integer) {
            int beanVersion = Integer.parseInt(obj.toString());
            if (dbVersion != beanVersion) {
                String msg = "already update from other user.bean-version=" + beanVersion + " db-version=" + dbVersion;
                throw new LockVersionException(msg);
            }
        } else {
            return recNum;
        }
        return recNum;
    }

    public int delete(Criteria crt) throws TransactionException {
        String sql = crt.toDeleteString();
        return this.transaction.execute(sql);
    }

    public List select(Criteria crt) throws TransactionException {
        ArrayList<Object> result = new ArrayList<Object>();
        Records list = null;
        list = this.transaction.select(crt.toSelectString());
        RecordMap recordMap = crt.getRecord();
        for (int i = 0; i < list.size(); ++i) {
            Record record = (Record)list.get(i);
            Object obj = this.createCurrentObject(crt, recordMap, record);
            HashMap oneToManyRecordMaps = crt.getOneToManyRecordMaps();
            Set mKeySet = oneToManyRecordMaps.keySet();
            Iterator mIt = mKeySet.iterator();
            int childCount = 0;
            while (mIt.hasNext()) {
                ArrayList<Object> childs = new ArrayList<Object>();
                String propertyName = (String)mIt.next();
                RecordMap oneToManyRecordMap = (RecordMap)oneToManyRecordMaps.get(propertyName);
                for (childCount = i; childCount < list.size(); ++childCount) {
                    Record child = (Record)list.get(childCount);
                    Object oneToManyObj = this.createObject(oneToManyRecordMap, child);
                    childs.add(oneToManyObj);
                    Object chkObj = this.createObject(recordMap, child);
                    if (RecordMap.isEquals(obj, chkObj, recordMap)) continue;
                    if (childCount <= 1) break;
                    --childCount;
                    break;
                }
                BeanUtil.setProperty(obj, propertyName, childs);
            }
            if (crt.isOneToMany()) {
                i = childCount;
            }
            result.add(obj);
        }
        return result;
    }

    private Object createCurrentObject(Criteria crt, RecordMap recordMap, Record record) throws TransactionException {
        Object obj = this.createObject(recordMap, record);
        HashMap fkRecordMaps = crt.getFkRecordMaps();
        Set keySet = fkRecordMaps.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            RecordMap fkRecordMap = (RecordMap)fkRecordMaps.get(propertyName);
            Object fkObj = this.createObject(fkRecordMap, record);
            BeanUtil.setProperty(obj, propertyName, fkObj);
        }
        return obj;
    }

    private Object createObject(RecordMap recordMap, Record record) throws TransactionException {
        Object obj = BeanUtil.createInstance(recordMap.getClassName());
        Set keySet = recordMap.getFields().keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FieldMap field = (FieldMap)recordMap.getFields().get(key);
            Object value = record.get(field.getColumAsName());
            try {
                field.setPropertyValue(obj, value);
            }
            catch (Exception e) {
                System.out.print(obj.getClass().getName() + ":");
                System.out.print(field.getPropertyName());
                System.out.println(":" + value);
                e.printStackTrace();
            }
        }
        return obj;
    }

    public int getNewId(String tableName, String pkCulomName) {
        int id = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select MAX(");
        sql.append(tableName).append(".").append(pkCulomName);
        sql.append(") AS NEW_ID FROM ").append(tableName);
        Records result = this.transaction.select(sql.toString());
        if (result.size() > 0) {
            Record record = result.getRecord(0);
            id = record.getInt("NEW_ID");
            ++id;
        }
        return id;
    }

    public int getNewId(String tableName) {
        int id = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select COUNT(*) AS NEW_ID FROM " + tableName);
        Records result = this.transaction.select(sql.toString());
        if (result.size() > 0) {
            Record record = result.getRecord(0);
            id = record.getInt("NEW_ID");
            ++id;
        }
        return id;
    }

    public int getNewIdFromAutoNumber(String tableName) {
        int id = 0;
        AutoNumberDao dao = new AutoNumberDao();
        try {
            id = dao.getNext(tableName);
        }
        catch (Exception e) {
            id = this.getNewId(tableName);
        }
        return id;
    }
}

