package org.itscool.commons.util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * ̑Ó`FbNs[eBeBNXł
 * @author kanou
 */
public class InputCheckUtil {
    /**
     * p[^null͋󕶎łȂƂ؂܂
     * @param paramValue p[^w肵܂
     * @return ؂ꍇtrueԂ܂
     */
    public static boolean isNotNull(String paramValue){
        boolean ret = true;
        
        if( paramValue == null || paramValue.toString().length() == 0){
            ret = false;
        }
        
        return ret;
    }
    
    /**
     * Sp`FbN<br>
     * ŗ^ꂽ񂪁ASđSpł邩ǂ`FbN
     * 郁\bhłB<br>
     *
     * SđSp̏ꍇ true ASpȊO݂ꍇ false Ԃ܂B<br>
     * @param str ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkFullSize(String str) {
        byte []bytes;
        if( str == null ) return false;
        
        bytes = str.getBytes();
        
        // lengthQ{
        int beams = str.length() * 2;
        
        int enterCounter = 0;
        
        StringBuffer sb = new StringBuffer(str);
        
        for (int i=0; i < str.length(); i++) {
            // sR[h͑ΏۊOƂ
            if ('\n' == sb.charAt(i)) {
                beams = beams - 2;
            }
        }
        
        // lengtĥQ{ƃoCgقȂꍇ͔p܂܂Ă
        if (beams != bytes.length) {
            return false;
        }
        
        return true;
    }
    
    /**
     * p`FbN<br>
     * ŗ^ꂽ񂪁ASĔpł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔp̏ꍇ true ApȊO݂ꍇ false Ԃ܂B<br>
     * @param str ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkHalfSize(String str) {
        byte [] bytes;
        if(!checkRequerd(str)) return false;
        
        bytes = str.getBytes();
        
        int beams = str.length();
        int enterCounter = 0;
        
        StringBuffer sb = new StringBuffer(str);
        
        for (int i=0; i < str.length(); i++) {
            //sR[h͑ΏۊOƂ
            if ('\n' == sb.charAt(i)) {
                beams = beams - 2;
            }
//	        //pXy[X͑ΏۊOƂ
//	        else if(' ' == sb.charAt(i)){
//	        	beams = beams - 2;
//	        }
        }
        
        //lengthƃoCgقȂꍇ͑Sp܂܂Ă
        if (beams != bytes.length) {
            return false;
        }
        
        return true;
    }
    
    /**
     * p`FbN<br>
     * ŗ^ꂽ񂪁ASĔpł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔp̏ꍇ true ApȊO݂ꍇ false Ԃ܂B
     * @param str ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkDigit(String input) {
        if(!checkRequerd(input)) return false;
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            
            if ( (c < '0' || c > '9') ) {
                //łȂ
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * pp`FbN<br>
     * ŗ^ꂽ񂪁ASĔppł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔpp̏ꍇ true AppȊO݂ꍇ false Ԃ܂B
     * @param input ͕
     * @return pp̏ꍇtrueԂ܂
     */
    public static boolean checkAlphabet(String input) {
        if(!checkRequerd(input)) return false;
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            if ( (c < 'a' || c > 'z') &&        //At@xbgłȂ
                (c < 'A' || c > 'Z') ) {       //啶At@xbgłȂ
                //pXy[X͑ΏۊO
                if( c == ' '){
                    continue;
                }
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * pp`FbN<br>
     * ŗ^ꂽ񂪁ASďppł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔpp̏ꍇ true AppȊO݂ꍇ false Ԃ܂B
     * @param input ͕
     * @return pp̏ꍇtrueԂ܂
     */
    public static boolean checkSmallAlphabet(String input) {
        if(!checkRequerd(input)) return false;
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            if ( (c < 'a' || c > 'z')){        //At@xbgłȂ
                //pXy[X͑ΏۊO
                if( c == ' '){
                    continue;
                }
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * 啶pp`FbN<br>
     * ŗ^ꂽ񂪁ASđ啶ppł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔpp̏ꍇ true AppȊO݂ꍇ false Ԃ܂B
     * @param input ͕
     * @return pp̏ꍇtrueԂ܂
     */
    public static boolean checkLargeAlphabet(String input) {
        if(!checkRequerd(input)) return false;
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            if ( (c < 'A' || c > 'Z') ) {       //啶At@xbgłȂ
                //pXy[X͑ΏۊO
                if( c == ' '){
                    continue;
                }
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * pp`FbN<br>
     * ŗ^ꂽ񂪁ASĔppł邩ǂ
     * `FbN郁\bhłB<br>
     * SĔpp̏ꍇ true AppȊO݂ꍇ false Ԃ܂B
     * @param input ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkDigitAlphabet(String input) {
        if(!checkRequerd(input)) return false;
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            if ( (c < '0' || c > '9') &&        //łȂ
                (c < 'a' || c > 'z') &&        //At@xbgłȂ
                (c < 'A' || c > 'Z') ) {       //啶At@xbgłȂ
                //pXy[X͑ΏۊO
                if( c == ' '){
                    continue;
                }
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * pJi`FbN<br>
     * ŗ^ꂽ񂪁ASĔpJił邩ǂ
     * `FbN郁\bhłB<br>
     * SĔpJȉꍇ true ApJiȊO݂ꍇ false Ԃ܂B
     * @param input ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkHankakuKana(String input) {
        if(!checkRequerd(input)) return false;
        
        final String HANKAKU_KANA = "" +
            "ܦݧ߰";
        
        for (int i = 0; i < input.length(); i++) {
            char c = input.charAt(i);
            
            if ( -1 == HANKAKU_KANA.indexOf( ( int ) c ) ) {
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * ̌`FbN<br>
     * ŗ^ꂽ񂪁Aw肳ꂽ͈͓̔ł邩ǂ
     * `FbN郁\bhłB<br>
     * ̓oCgŃ`FbNȀ͈͓ꍇ true A͈͊Ȍꍇ false Ԃ܂B
     * @param val f[^
     * @param min ŏ
     * @param max ő包
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkStrLength( String val, int min, int max){
        if(!checkRequerd(val)) return false;
        
        int strlen = 0;
        
        if ( val == null ) {
            return false;
        }
        
        strlen = val.getBytes().length;
        
        if ( strlen < min || strlen > max ) {
            return false;
        }
        
        return true;
    }
    
    /**
     * ľ`FbN<br>
     * ŗ^ꂽ񂪁Aw肳ꂽ͈͓̔ł邩ǂ
     * `FbN郁\bhłB<br>
     * ̓oCgŃ`FbNȀ͈͓ꍇ true A͈͊Ȍꍇ false Ԃ܂B
     * @param str f[^
     * @param min ŏ
     * @param max ő包
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkDigitLength( String str, double min, double max){
        if(!checkRequerd(str)) return false;
        
        double value;
        try{
            value = Double.parseDouble(str);
        }catch(Exception e){
            return false;
        }
        if(min <= value && value <= max){
            return true;
        }else{
            return false;
        }
    }
    
    /**
     * K{`FbN<br>
     * @param str ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkRequerd(String str){
        if(str==null || str.length()==0){
            return false;
        }else{
            return true;
        }
    }
    
    /**
     * dbԍ`FbN
     * @param data ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkTelNo(String data){
        if(!checkRequerd(data)) return false;
        
        String koubun = "\\d{1,4}?-\\d{1,4}?-\\d{1,4}";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b= matcher.matches();
        
        return true;
    }
    
    /**
     * [AhX`FbN
     * @param data ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkMailAddr(String data){
        if(!checkRequerd(data)) return false;
        
        String koubun = "[!#-9A-~]+@[a-z0-9-_]+\\.+[a-z0-9-_]+\\.+[a-z0-9-]";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b= matcher.matches();
        
        return true;
    }
    
    /**
     * X֔ԍ`FbN
     * @param data ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkPostCode(String data){
        if(!checkRequerd(data)) return false;
        
        String koubun = "\\d{3}-\\d{4}";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b= matcher.matches();
        
        return true;
    }
    
    /**
     * URL`FbN
     * uhttp://v́uhttp://vł͂܂邱Ƃ\܂B
     * u\wvA?Z\܂B
     * u\dv0?9\܂B
     * u[\w\d/%#$&?()~_.=+-]v[]̂ꂩ̕\܂B
     * u+vƁAOq̕1ȏ㑱Ƃ\܂B
     *
     * @param data ̓f[^
     * @return w肳ꂽf[^Ƀ}b`ꍇtrueԂ܂
     */
    public static boolean checkUrl(String data){
        if(!checkRequerd(data)) return false;
        
        String koubun = "http://[\\w\\d/%#$&?()~_.=+-]+";
        Pattern pattern = Pattern.compile(koubun);
        Matcher matcher = pattern.matcher(data);
        boolean b= matcher.matches();
        
        return true;
    }
}
