package org.itscool.commons.document;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class XmlDocument {
    protected Document document;
    
    /**
     * oɓo^ĂhLg擾܂B
     * @return ̃IuWFNgɓo^ĂhLgԂ܂
     */
    public Document getDocument() {
        return document;
    }
    
    /**
     * [gurootNamevŎw肵VDocumentCX^X
     * 쐬܂
     * @param rootName ̃hLg̃[gvf̖O
     * @throws Exception
     */
    public XmlDocument(String rootName) throws Exception{
        
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document document = domImpl.createDocument("",rootName,null);
        init(document);
    }
    
    /**
     * w肳ꂽDocumentCX^Xg܂
     * @param document DocumentCX^X
     * @throws Exception
     */
    public XmlDocument(Document document) throws Exception{
        init(document);
    }
    
    /**
     * w肳ꂽDocumentIuWFNgoɃZbg܂B<br>
     * AJDK1.5ȏ̊gpĂꍇ́AVXevpeB
     * javax.xml.transform.TransformerFactoryXV܂B
     * @param document oɃZbgDocumentCX^X
     */
    protected void init(Document document){
        String version = System.getProperty("java.version");
        if( version.indexOf("1.4") != 0 ){
            System.setProperty("javax.xml.transform.TransformerFactory",
                "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
        this.document = document;
    }
    
    /**
     * TransformerFactoryNX
     *
     * XMLXSLT̂ɁATransformer NXg܂B
     *  TransformerFactoryNX o܂B
     * TransformerFactory.newInstance();
     *
     * JDK1.4 ł org.apache.xalan.processor.TransformerFactoryImpl JDK5.0 ł
     * com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl
     *
     * ԂĂ悤łBJDK5.0ɂȂ com.sun pbP[W ̎ɂȂĂ݂łˁB
     *
     * AJDK5.0 ł xalan.jar NXpXɊ܂߂ĎsƁA
     *
     * org.apache.xalan.processor.TransformerFactoryImpl
     *
     * ɂȂ܂B ̗R JDKAPIDocɂ܂` APIhLgɂ
     * To菇͈ȉɂȂ܂B
     *
     * javax.xml.transform.TransformerFactory VXevpeBgp JRE
     * fBNg̃vpeBt@C lib/jaxp.properties gpB
     * ̍\t@C͕Wjava.util.Properties `łAL̂悤ɒ
     * `ꂽVXevpeBłL[NX̊Sw̖O܂
     *
     * \ł΁AJAR dlŏڍׂɐĂT[rX API gpāA
     * NX𔻒肷B T[rX API ́AsɎgpł
     * jar  META-INF/services/javax.xml.transform.TransformerFactory t@C
     * NX
     *
     * vbgtH[̃ftHg TransformerFactory CX^X
     *
     * xalan.jar  Ă݂ƥ ܂ˁA
     *
     * META-INF/services/javax.xml.transform.TransformerFactorỹt@CB
     *
     * ̒gĂ݂ org.apache.xalan.processor.TransformerFactoryImpl
     *
     * ƋLqĂ܂BꂪLɂȂĂ킯łˁB
     *
     * FactoryNXɂāAǂ̎NXgH wł͕̂֗
     * @\ȂłAɂ n}邱ƂB
     *
     * Ƃ΁A tomcat5   Servlet ɂ Transformer XSLT
     * Ă vOB
     *
     * JDK1.4tomcat𓮂ƁA܂̂ɁA JDK5.0tomcat𓮂ƁA
     * Provider org.apache.xalan.processor.TransformerFactoryImpl not Found.
     * ăG[łB
     * ȁ[āAY񂾕̂ł́H
     *
     * ܂ł̘b sƗlH
     *  A̗R tomcat̂gĂ TransformerFactory̎
     * org.apache.xalan.processor.TransformerFactoryImpl
     * gĂ炾Ǝv܂B
     * JDK1.4ł́A܂(?) LNX JDK̒Ɋ܂܂Ă̂ővł
     * AJDK5.0ł ܂܂ĂȂ̂ G[ɂȂłˁB
     *
     * ̏ꍇ̉@ƂĂ 傫2ށB
     *
     * ڂ org.apache.xalan.processor.TransformerFactoryImpl 
     * xalan.jar ƂtomcatlibɂꂿāA
     * org.apachepbP[Wg悤ɂႤB
     *
     * ڂ JDK5.0Ɋ܂܂Ă
     * com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl
     * gĂ悤ȐݒɂႤB
     *
     * ݒ@ JDKAPIhLgʂȂłA@ɂ肯tomcat
     * e邩ȂB
     *
     * Ƃ΁AVXevpeBɒǉ
     * System.setProperty("javax.xml.transform.TransformerFactory",
     * "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
     * ĕ@ JRElib/jaxp.properties ɒǉ@B
     *
     * ꉞł邯ǁAVXevpeBɒǉ_ŁA
     * tomcat܂ނVM̑SẴvOɉeH
     *
     * 񂶂[ȐƂ 쐬JAR
     * META-INF/services/javax.xml.transform.TransformerFactory ̃t@C
     * com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl
     * w肵ႤB JDK1.4œꂽƂɂ AEg łǂˁBB
     *
     * JDK1.4A5.0œOK̂̂邽߂ɂͥ قƑË
     * FactoryNXg񂶂ȂāAg
     * Transformer NXŃCX^XႤ
     * ̂ԊmȂȂ[
     *
     * [ ̕ĂقƖʓ|łB
     *
     *  TomcatJDK̑gݍ킹݂ mFĂłA
     * Ȃ ٗlɔĂEEEE
     *
     */
    public String parseText(String encoding) throws Exception{
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        
        //o͂̃GR[fBOZbg
        if( encoding != null && encoding.length() > 0 ){
            Properties properties = new Properties();
            properties.setProperty("encoding", encoding);
            transformer.setOutputProperties(properties);
//	        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
        }
        transformer.transform(source, new StreamResult(os));
        
        return new String(os.toByteArray(), encoding);
    }
}
