/*
 * URLDecodeUtilTest.java
 *
 * Created on 2007/03/13, 21:10
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package test.org.itscool.commons.util;

import junit.framework.TestCase;
import org.itscool.commons.util.URLDecodeUtil;

/**
 *
 * @author KANO
 */
public class URLDecodeUtilTest extends TestCase{
    
    public void testFilter1(){
        String test = "<";
        String result = URLDecodeUtil.filter(test);
        assertEquals(result, "&lt;");
    }
    
    public void testFilter2(){
        String test = ">";
        String result = URLDecodeUtil.filter(test);
        assertEquals(result, "&gt;");
    }
    
    public void testFilter3(){
        String test = "&";
        String result = URLDecodeUtil.filter(test);
        assertEquals(result, "&amp;");
    }
    
    public void testFilter4(){
        String test = "\"";
        String result = URLDecodeUtil.filter(test);
        assertEquals(result, "&quot;");
    }
    
    public void testFilter5(){
        String test = "<a href=\"http://aaa.bbb.ccc>{</a>";
        String result = URLDecodeUtil.filter(test);
        assertEquals(result, "&lt;a href=&quot;http://aaa.bbb.ccc&gt;{&lt;/a&gt;");
    }
}
