/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.itscool.commons.document.DocumentBean;

public class DocumentBeanParser {
    public static DocumentBean parseBean(Object bean) throws IllegalAccessException, InvocationTargetException {
        DocumentBean pBean = new DocumentBean();
        Object obj = bean;
        Class<?> clazz = obj.getClass();
        String clazzName = clazz.getName();
        int index = clazzName.lastIndexOf(".");
        clazzName = clazzName.substring(index + 1, clazzName.length());
        pBean.setName(clazzName);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Iterator<Object> property;
            Method method = methods[i];
            String getterName = method.getName();
            if (getterName.indexOf("get") != 0 && getterName.indexOf("is") != 0 || getterName.indexOf("getClass") == 0) continue;
            if (method.getReturnType().isArray()) {
                Iterator<Object> iterator;
                Object[] collection = (Object[])method.invoke(obj, null);
                property = iterator = Arrays.asList(collection).iterator();
            } else {
                property = method.invoke(obj, null);
            }
            int firstMemberIndex = 3;
            if (getterName.indexOf("is") == 0) {
                firstMemberIndex = 2;
            }
            String memberName = getterName.substring(firstMemberIndex, getterName.length());
            memberName = memberName.substring(0, 1).toLowerCase() + memberName.substring(1, memberName.length());
            if (property == null) continue;
            Class<?> propertyType = property.getClass();
            if (propertyType != null && propertyType.getName().indexOf("java.") < 0 && propertyType.getName().indexOf("javax.") < 0) {
                pBean.put(memberName, DocumentBeanParser.parseBean(property));
                continue;
            }
            pBean.put(memberName, property.toString());
        }
        return pBean;
    }
}

