package org.itscool.weber.io;

import java.io.IOException;
import java.util.HashMap;

import org.itscool.commons.document.XmlConfigReader;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * weber-config.xmlt@C&lt;messages&gt;vf͂NXł
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class MessageConfigReader extends XmlConfigReader{
    
    /**
     * XMLt@C&lt;roles&gt;vf͂܂<br>
     * ͌ʂnodeListɃZbg܂<br>
     * @param hashMap XML̉͌
    */
    protected void doCreate(HashMap hashMap) throws IOException{
        /* [g^O擾 */
        Element root = document.getDocumentElement();
        if( root == null ){
            String err = "Can not root element at weber-message.xml(" + 
                getClass().getName()+")";
            throw new IOException(err);
        }
        /* action-mappings ̎擾*/
        NodeList rolesList = root.getElementsByTagName("messages");
        if( rolesList != null ){
            Node roles = rolesList.item(0);
            if( roles != null ){
                createMessages(roles, hashMap);
            }
        }
    }
    
    /**
     * &lt;message&gt;vf͂܂
     * @param roles &lt;massages&gt;vf
     * @param hashMap ͌&lt;massages&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createMessages(Node roles, HashMap hashMap){
        NodeList rolesChilds = roles.getChildNodes();
        
        for( int i = 0; i < rolesChilds.getLength(); i++) {
            Node message = rolesChilds.item(i);
            if( message.getNodeName().equals("message")){
                createMessage(message, hashMap);
            }
        }
    }
    
    /**
     * &lt;message&gt;vf̑͂܂
     * @param message &lt;message&gt;vf
     * @param hashMap ͌&lt;message&gt;vfǉm[hXg
     * @throws Exception
     */
    protected void createMessage(Node message, HashMap hashMap){
        NamedNodeMap attributes = message.getAttributes();
        Node key = attributes.getNamedItem("key");
        Node value = attributes.getNamedItem("value");
        hashMap.put( key.getNodeValue(), value.getNodeValue() );
        
    }
}
