package org.itscool.commons.property;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.itscool.commons.util.StringUtil;

/**
 * ͕16i`Ńt@Cɏ񂾂Aǂݍ񂾂肷
 * ׂ̃NXł
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
*/
public class HexPropertyFile extends PropertyFile{
    /**
     * vpeBt@C̏s܂
     * @param path vpeBt@C܂ރpX
     * @throws IOException
     */
    public HexPropertyFile(String path) throws IOException{
        super(path);
    }
    
    /**
     * vpeB擾܂<BR>
     * vpeB"ISO-8859-1"ɃGR[fBOꂽoCgɂȂ܂
     * @param key vpeB
     * @return vpeBbyte[]`ŕԂ܂
     * @throws IOException
     */
    public byte[] readHex(String key){
        String strData = super.read(key);
        if( strData == null ){
            return null;
        }
        strData = StringUtil.decodeHex( strData ); 
        byte[] byteData = null;
        try{
            byteData = strData.getBytes("ISO-8859-1");
        }catch(UnsupportedEncodingException uee ){
            uee.printStackTrace();
        }
        return byteData;
    }
    
    /**
     * byte_dataŎw肳ꂽoCgkeyŎw肳ꂽvpeBɏ݂܂
     * byte_data"ISO-8859-1"ɃGR[fBOꂽStringCX^Xɕϊ܂
     * @param key vpeB
     * @param byteData vpeBɃZbgoCg
     * @param append ǉ[hBtruew肳ꂽꍇ͊̃vpeBt@Cɒǉ܂
     * @return vpeB̒ǉɐꍇtrueԂ܂B̃vpeBɑ݂
     * ꍇfalseԂ܂
     * @throws IOException
    */
    public boolean writeHex(String key, byte[] byteData, boolean append)
    throws IOException{
        String data = new String(byteData, "ISO-8859-1");
        data = StringUtil.encodeHex(data);
        
        boolean ret = super.write(key, data, append);
        
        return ret;
    }
}
