package org.itscool.commons.connection;

import java.sql.PreparedStatement;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.dao.PreparedStatementWrapper;

/**
 * TransactionCX^XThreadLocaliXbhPʂňӂƂȂϐj
 * ǗNXł<br/>
 * T[ubgŎgpꍇAT[ubg1NGXg/X|XA1Xbh
 * Ɋ蓖Ă܂<br/>
 * ̃NXgăRlNVOpenSessionInViewp^[𗘗p邱Ƃł܂
 * @author kano
 */
public class TransactionUtil {
    
    private static final ThreadLocal threadTransaction = new ThreadLocal();
    
    /**
     * gUNVJn܂B
     */
    public static void beginTransaction(){
        getTransaction();
    }
    
    /**
     * gUNVCX^X擾AXbh[JCX^XɃZbg܂<BR>
     * gUNVĂȂꍇ́AgUNV̏s܂B
     * @return TransactionCX^XԂ܂B
     */
    public static Transaction getTransaction() {
        Transaction tx = (Transaction) threadTransaction.get();
        if (tx == null) {
            BeanFactory factory = BeanFactory.getInstance();
            ConnectionManager mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            tx = mgr.getTransaction();
            threadTransaction.set(tx);
        }
        return tx;
    }
    
    /**
     * PreparedStatement擾܂
     * @param sql SQL
     * @return PreparedStatementԂ܂
     */
    public static PreparedStatement getPreparedStatement(String sql){
        Transaction trn = getTransaction();
        PreparedStatement pstmt = trn.getPrepareStatement(sql);
        return pstmt;
    }
    /**
     * PrepareStatementWrapper擾܂
     * @param sql SQL
     * @return PrepareStatementWrapperԂ܂
     */
    public static PreparedStatementWrapper getPreparedStatementWrapper(String sql){
            Transaction trn = getTransaction();
            PreparedStatement pstmt = trn.getPrepareStatement(sql);
            PreparedStatementWrapper wrapper = new PreparedStatementWrapper(pstmt);
            return wrapper;
    }
    /**
     * R~bgs܂
     */
    public static void commitTransaction() {
        // Would be written as a no-op in an EJB container with CMT
        Transaction tx = (Transaction) threadTransaction.get();
        try {
            if ( tx != null ) {
                tx.commit();
            }
            //threadTransaction.set(null);
        } catch (TransactionException ex) {
            rollbackTransaction();
            throw ex;
        }
    }
    
    /**
     * [obNs܂
     */
    public static void rollbackTransaction() {
        // Would be written as a no-op in an EJB container with CMT (maybe setRollBackOnly...)
        Transaction tx = (Transaction) threadTransaction.get();
        try {
            //threadTransaction.set(null);
            if ( tx != null ) {
                tx.rollback();
            }
        } catch (TransactionException ex) {
            throw ex;
        }
    }
    
    /**
     * TransactionCX^XRlNVv[ɕԂ܂
     */
    public static void returnTransaction(){
        Transaction tx = (Transaction) threadTransaction.get();
        if( tx != null ){
            BeanFactory factory = BeanFactory.getInstance();
            ConnectionManager mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            mgr.returnTransaction(tx);
        }
        threadTransaction.set(null);
    }
}
