/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;

public class RecordMapOneToManyFactory
extends RecordMapFactory {
    public static final String ONE_TO_MANY = "ONE_TO_MANY_";

    public static HashMap createFkRecordMaps(String className) {
        try {
            Class<?> entity = Class.forName(className);
            return RecordMapOneToManyFactory.createOneToManyRecordMaps(entity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap createOneToManyRecordMaps(Class entity) {
        HashMap fkRecordMaps = new HashMap();
        fkRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(entity, fkRecordMaps);
        return fkRecordMaps;
    }

    public static HashMap createOneToManyRecordMaps(Class entity, HashMap fkRecordMaps) {
        Class superClazz = entity.getSuperclass();
        if (superClazz != null) {
            fkRecordMaps = RecordMapOneToManyFactory.createOneToManyRecordMaps(superClazz, fkRecordMaps);
        }
        String clazzName = entity.getName();
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            try {
                String staticName = field.getName();
                int index = staticName.indexOf(ONE_TO_MANY);
                if (modifier != 25 || index != 0) continue;
                String propertyName = staticName.substring(ONE_TO_MANY.length(), staticName.length());
                String propertyType = RecordMapOneToManyFactory.getPropertyType(entity, propertyName);
                System.out.println(propertyType);
                RecordMap recordMap = RecordMapFactory.createRecordMap(propertyType);
                if (propertyType == null) continue;
                recordMap.setClassName(propertyType);
                fkRecordMaps.put(propertyName, recordMap);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return fkRecordMaps;
    }
}

