/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.FieldMap;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;

public class RecordMapFkFactory
extends RecordMapFactory {
    public static final String FK_COLUM = "FK_COLUM_";
    public static final String FK_TABLE = "FK_TABLE_";

    public static HashMap createFkRecordMaps(String className) {
        try {
            Class<?> entity = Class.forName(className);
            return RecordMapFkFactory.createFkRecordMaps(entity);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap createFkRecordMaps(Class entity) {
        HashMap fkRecordMaps = new HashMap();
        fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity, fkRecordMaps);
        return fkRecordMaps;
    }

    public static HashMap createFkRecordMaps(Class entity, HashMap fkRecordMaps) {
        Class superClazz = entity.getSuperclass();
        if (superClazz != null) {
            fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(superClazz, fkRecordMaps);
        }
        String clazzName = entity.getName();
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            try {
                String staticName = field.getName();
                int index = staticName.indexOf(FK_TABLE);
                if (modifier != 25 || index != 0) continue;
                String propertyName = staticName.substring(FK_TABLE.length(), staticName.length());
                String propertyType = RecordMapFkFactory.getPropertyType(entity, propertyName);
                RecordMap recordMap = RecordMapFactory.createRecordMap(propertyType);
                RecordMapFkFactory.setForignKey(recordMap, entity, FK_TABLE + propertyName, FK_COLUM + propertyName + "_");
                if (propertyType == null) continue;
                recordMap.setClassName(propertyType);
                fkRecordMaps.put(propertyName, recordMap);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return fkRecordMaps;
    }

    private static void setForignKey(RecordMap recordMap, Class entity, String tableHeaderName, String columHeaderName) {
        Object obj = BeanUtil.createInstance(entity.getName());
        String tableName = RecordMapFkFactory.getTableName(entity, obj, tableHeaderName);
        recordMap.setClassName(entity.getName());
        recordMap.setTableName(tableName);
        Field[] fields = entity.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifier = field.getModifiers();
            try {
                String staticName = field.getName();
                int index = staticName.indexOf(columHeaderName);
                if (modifier != 25 || index != 0) continue;
                String fieldName = (String)field.get(obj);
                fieldName = fieldName.toUpperCase();
                String propertyName = staticName.substring(columHeaderName.length(), staticName.length());
                FieldMap fieldMap = recordMap.getFieldByFieldName(fieldName);
                fieldMap.setFkPropertyName(propertyName);
                fieldMap.setForignKey(true);
                continue;
            }
            catch (IllegalAccessException e) {
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" + "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
            catch (NullPointerException e) {
                String err = "[" + obj.getClass().getName() + ":" + tableName + "]" + "setForignKey() failed(" + RecordMapFkFactory.class.getName() + ") (" + e.getMessage() + ")";
                throw new DaoRuntimeException(err);
            }
        }
        HashMap records = recordMap.getFields();
        Set keySet = records.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                Object key = iterator.next();
                FieldMap fieldMap = (FieldMap)records.get(key);
                String propertyName = fieldMap.getPropertyName();
                Field field = BeanUtil.getField(entity, propertyName);
                if (field == null) continue;
                String type = field.getType().getName();
                fieldMap.setType(type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

