/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.dao.FieldMap;

public class RecordMap {
    private String className;
    private String tableName;
    private HashMap fields = new HashMap();

    public String toString() {
        String line = System.getProperty("line.separator");
        String tab = "  ";
        StringBuffer sb = new StringBuffer();
        sb.append("TABLE[").append(this.tableName).append("] ");
        sb.append("CLASS[").append(this.className).append("] ");
        sb.append(line);
        Set keySet = this.fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)this.fields.get(key);
            sb.append(tab).append("KEY[").append(key).append("] ");
            sb.append("COLUM[").append(fieldMap.getColumName()).append("] ");
            sb.append("PROPERTY[").append(fieldMap.getPropertyName()).append("] ");
            sb.append(line);
        }
        return sb.toString();
    }

    public RecordMap(String className, String tableName) {
        this.tableName = tableName;
        this.className = className;
    }

    public String getClassOnlyName() {
        int classOnlyNameIndex = this.className.lastIndexOf(".") + 1;
        String classOnlyName = this.className.substring(classOnlyNameIndex, this.className.length());
        return classOnlyName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addField(FieldMap field) {
        this.fields.put(this.tableName + "." + field.getColumName(), field);
    }

    public HashMap getFields() {
        return this.fields;
    }

    public FieldMap getField(String tableDotFieldName) {
        FieldMap field = (FieldMap)this.fields.get(tableDotFieldName.toUpperCase());
        return field;
    }

    public FieldMap getFieldByFieldName(String argFieldName) {
        String fieldName = argFieldName.toUpperCase();
        Set keySet = this.fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)this.fields.get(key);
            if (!fieldMap.getColumName().equals(fieldName)) continue;
            return fieldMap;
        }
        return null;
    }

    public FieldMap getFieldByPropertyName(String propertyName) {
        Set keySet = this.fields.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            FieldMap fieldMap = (FieldMap)this.fields.get(key);
            if (!fieldMap.getPropertyName().equals(propertyName)) continue;
            return fieldMap;
        }
        return null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

