/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.testcase;

import java.net.URL;
import java.util.LinkedList;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionUtil;
import org.itscool.weber.action.Action;
import org.itscool.weber.testcase.DbTestConfigReader;
import org.itscool.weber.testcase.FieldData;
import org.itscool.weber.testcase.RecordData;
import org.itscool.weber.testcase.TableData;
import org.itscool.weber.testcase.WeberDbTestCaseInitException;
import org.itscool.weber.testcase.WeberTestCase;
import org.itscool.weber.user.User;

public abstract class WeberDbTestCase
extends WeberTestCase {
    protected ConnectionManager mgr;
    protected static LinkedList testDataList = new LinkedList();
    private static boolean initFlg = false;

    public WeberDbTestCase() {
        if (!initFlg) {
            this.init();
            initFlg = true;
        }
    }

    public void init() {
        try {
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URL diconfigUrl = parent.getResource("di-config.xml");
            if (diconfigUrl == null) {
                String err = "di-config.xml path is null.";
                WeberDbTestCase.fail((String)err);
                log.error(err);
                return;
            }
            String configFwName = diconfigUrl.getPath();
            BeanFactory factory = BeanFactory.getInstance();
            factory.create(configFwName);
            this.mgr = (ConnectionManager)factory.createInstance("ConnectionManager");
            this.mgr.init();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            this.mgr.destroy();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
    }

    public void tearDown() {
        TransactionUtil.returnTransaction();
    }

    public void initTables(String configName) {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL configUrl = parent.getResource(configName);
        String path = configUrl.getPath();
        DbTestConfigReader dbReader = new DbTestConfigReader();
        try {
            testDataList.clear();
            dbReader.create(path, testDataList);
            this.clearTables();
            this.insertDatas();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
    }

    protected void clearTables() {
        Transaction transaction = TransactionUtil.getTransaction();
        if (testDataList.size() == 0) {
            return;
        }
        System.out.println("---- delete data start --- ");
        try {
            for (int i = testDataList.size(); i > 0; --i) {
                TableData table = (TableData)testDataList.get(i - 1);
                StringBuffer sql = new StringBuffer("Delete From ");
                sql.append(table.getTableName());
                System.out.println(sql.toString());
                transaction.execute(sql.toString());
                TransactionUtil.commitTransaction();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", Execute role back.");
            TransactionUtil.rollbackTransaction();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
        finally {
            TransactionUtil.returnTransaction();
        }
        System.out.println("---- delete data end --- ");
    }

    protected void insertDatas() {
        Transaction transaction = TransactionUtil.getTransaction();
        System.out.println("---- insert data start --- ");
        try {
            for (int i = 0; i < testDataList.size(); ++i) {
                TableData table = (TableData)testDataList.get(i);
                for (int j = 0; j < table.getRecordSize(); ++j) {
                    FieldData field;
                    int k;
                    RecordData record = table.getRecordData(j);
                    StringBuffer sql = new StringBuffer("Insert Into ");
                    sql.append(table.getTableName());
                    sql.append(" ( ");
                    if (record.getFieldSize() == 0) continue;
                    for (k = 0; k < record.getFieldSize(); ++k) {
                        field = record.getFieldData(k);
                        sql.append(field.getName());
                        if (k + 1 >= record.getFieldSize()) continue;
                        sql.append(", ");
                    }
                    sql.append(" ) Values ( ");
                    for (k = 0; k < record.getFieldSize(); ++k) {
                        field = record.getFieldData(k);
                        sql.append(field.getValue());
                        if (k + 1 >= record.getFieldSize()) continue;
                        sql.append(", ");
                    }
                    sql.append(" )");
                    System.out.println(sql.toString());
                    transaction.execute(sql.toString());
                }
            }
            TransactionUtil.commitTransaction();
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", Execute role back.");
            TransactionUtil.rollbackTransaction();
            throw new WeberDbTestCaseInitException(e.getMessage());
        }
        finally {
            TransactionUtil.returnTransaction();
        }
        System.out.println("---- insert data end --- ");
    }

    public void assertDoExecute(Action action, Object form, String forward) throws Exception {
        try {
            super.assertDoExecute(action, form, forward);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if (trnStatus == Transaction.PLEASE_COMMIT) {
                TransactionUtil.commitTransaction();
            } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
                TransactionUtil.rollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCheckUserRole(Action action, User user, boolean ret) {
        try {
            super.assertCheckUserRole(action, user, ret);
        }
        finally {
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if (trnStatus == Transaction.PLEASE_COMMIT) {
                TransactionUtil.commitTransaction();
            } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
                TransactionUtil.rollbackTransaction();
            }
        }
    }

    public void assertValidate(Action action, String forward) throws Exception {
        try {
            super.assertValidate(action, forward);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            int trnStatus = TransactionUtil.getTransaction().getTranStatus();
            if (trnStatus == Transaction.PLEASE_COMMIT) {
                TransactionUtil.commitTransaction();
            } else if (trnStatus == Transaction.PLEASE_ROLLBACK) {
                TransactionUtil.rollbackTransaction();
            }
        }
    }
}

