/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.URLDecodeUtil;

public abstract class HttpGeneralForm
extends GeneralForm {
    private HashMap duplicateKeys = new HashMap();
    protected static AbstractLog log;

    protected abstract void doParseData(byte[] var1, String var2);

    public void doDefaultParseData(HttpServletRequest req, String encode) throws IOException {
        Map pmap = req.getParameterMap();
        Set hset = pmap.keySet();
        Iterator iter = hset.iterator();
        int hno = hset.size();
        while (iter.hasNext()) {
            String cValue;
            String value;
            String name = (String)iter.next();
            String[] values = (String[])pmap.get(name);
            if (values.length == 1) {
                try {
                    value = values[0];
                    cValue = URLDecodeUtil.decode(value.toString(), encode);
                    cValue = URLDecodeUtil.filter(cValue);
                    if (!cValue.equals(value)) {
                        log.warn("recieved cross scripting => " + value);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                log.trace("request param defaultParse key=" + name + " value=" + cValue);
                this.addParameter(name, (Object)cValue);
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                value = values[i];
                cValue = URLDecodeUtil.filter(value.toString());
                if (!cValue.equals(value)) {
                    log.warn("recieved cross scripting => " + value);
                }
                cValue = URLDecodeUtil.decode(cValue, encode);
                log.trace("request param defaultParse key=" + name + " value=" + cValue);
                this.addParameter(name, (Object)cValue);
            }
        }
        this.margeParamsByDuplicateKey();
    }

    public void addParameter(String key, Object obj) {
        int index = key.indexOf(".");
        if (index != -1) {
            key = key.substring(0, index);
        }
        Object chkObj = this.getParameter(key);
        if (obj instanceof String) {
            obj = URLDecodeUtil.filter(obj.toString());
        }
        if (chkObj != null) {
            ArrayList<Object> duplicateParams = (ArrayList<Object>)this.duplicateKeys.get(key);
            if (duplicateParams == null) {
                duplicateParams = new ArrayList<Object>();
                this.duplicateKeys.put(key, duplicateParams);
                duplicateParams.add(chkObj);
            }
            duplicateParams.add(obj);
        }
        super.addParameter(key, obj);
    }

    protected void margeParamsByDuplicateKey() {
        Set keySet = this.duplicateKeys.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String paramName = (String)it.next();
            List paramList = (List)this.duplicateKeys.get(paramName);
            super.removeParameter(paramName);
            super.addParameter(paramName, paramList);
        }
    }

    static {
        BeanFactory factory = BeanFactory.getInstance();
        try {
            log = (AbstractLog)factory.getInstance("Log");
            if (!log.isInit()) {
                log = (AbstractLog)factory.createInstance("Log");
            }
        }
        catch (Exception ioe) {
            log = SimpleLog.getInstance();
            log.info(ioe.getMessage());
        }
    }
}

