/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.dao.DaoRuntimeException;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.util.DateFormatUtil;

public class FieldMap {
    public static final String FLD_LOCK_VERSION = "LOCK_VERSION";
    public static final String FLD_UPDATE_DT = "UPDATE_DT";
    public static final String FLD_DELETE_FG = "DELETE_FG";
    public static final String FLD_DELETE_DT = "DELETE_DT";
    public static final String NULL_STRING = "null";
    private boolean primaryKey = false;
    private boolean forignKey = false;
    private String propertyName;
    private String fkPropertyName;
    private String type;
    private String columName;
    private RecordMap lnkRecordMap;

    public FieldMap() {
    }

    public FieldMap(String propertyName, String name, String type, RecordMap lnkRecordMap) {
        this.lnkRecordMap = lnkRecordMap;
        this.propertyName = propertyName;
        this.columName = name;
        this.type = type;
    }

    public String cnvSqlValue(Object obj) {
        String value = "";
        try {
            if (obj == null) {
                return NULL_STRING;
            }
            value = obj.toString();
            StringBuffer sb = new StringBuffer();
            if (this.getType().equals(String.class.getName()) && value == NULL_STRING) {
                sb.append(value);
            } else if (this.getType().equals(String.class.getName())) {
                sb.append("'");
                sb.append(FieldMap.convertDBText(value));
                sb.append("'");
            } else {
                if (this.getType().equals(Date.class.getName()) && obj instanceof Date) {
                    try {
                        if (obj == null || obj.toString().equals(NULL_STRING)) {
                            return NULL_STRING;
                        }
                        Date date = (Date)obj;
                        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        value = sdf1.format(date);
                        sb.append("'");
                        sb.append(value);
                        sb.append("'");
                    }
                    catch (Exception e) {
                        throw new DaoRuntimeException(e.getMessage() + " value = " + obj);
                    }
                }
                if (this.getType().equals(Date.class.getName()) && obj instanceof String) {
                    try {
                        if (obj == null || obj.toString().equals(NULL_STRING)) {
                            return NULL_STRING;
                        }
                        Date date = DateFormatUtil.parse(obj.toString());
                        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        value = sdf1.format(date);
                        sb.append("'");
                        sb.append(value);
                        sb.append("'");
                    }
                    catch (Exception e) {
                        throw new DaoRuntimeException(e.getMessage() + " value = " + obj);
                    }
                }
                if (this.getType().equals(Boolean.TYPE.getName()) || this.getType().equals("boolean")) {
                    boolean b = Boolean.valueOf(value);
                    if (b) {
                        sb.append(1);
                    } else {
                        sb.append(0);
                    }
                } else if (this.getType().equals("int")) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        value = "-1";
                    }
                    sb.append(value);
                } else {
                    sb.append(value);
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new DaoRuntimeException(e.getMessage() + " value = " + obj);
        }
    }

    public void setPropertyValue(Object obj, Object value) {
        if (this.getType().equals(Boolean.TYPE.getName())) {
            boolean bool = Boolean.parseBoolean((String)value);
            value = new Boolean(bool);
        } else if (this.getType().equals(Date.class.getName()) && value instanceof String && value != null) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String str = value.toString();
                Date date = sdf1.parse(str);
                value = date;
            }
            catch (Exception e) {
                throw new DaoRuntimeException(e.getMessage());
            }
        }
        BeanUtil.setProperty(obj, this.getPropertyName(), value);
    }

    public static String convertDBText(String strData) {
        int iLength = 0;
        int iCnt = 0;
        String strC = "";
        String new_strData = "";
        try {
            iLength = strData.length();
            for (iCnt = 0; iCnt < iLength; ++iCnt) {
                char chrC = strData.charAt(iCnt);
                if (chrC == '\'') {
                    strC = "''";
                    new_strData = new_strData + strC;
                    continue;
                }
                if (chrC == '\\') {
                    strC = String.valueOf(chrC) + String.valueOf(chrC);
                    new_strData = new_strData + strC;
                    continue;
                }
                new_strData = new_strData + chrC;
            }
            strData = new_strData;
            return strData;
        }
        catch (Exception e) {
            return strData;
        }
    }

    public static final String convColumWithTableName(String tblName, String columName) {
        StringBuffer sb = new StringBuffer();
        sb.append(tblName);
        sb.append(".").append(columName);
        return sb.toString().toUpperCase();
    }

    public static final String convColumAsName(String tblName, String columName) {
        StringBuffer sb = new StringBuffer();
        sb.append(tblName).append("_").append(columName);
        return sb.toString().toUpperCase();
    }

    public String getType() {
        return this.type;
    }

    public String getColumName() {
        return this.columName;
    }

    public void setColumnName(String columName) {
        this.columName = columName;
    }

    public String getColumWithTableName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lnkRecordMap.getTableName());
        sb.append(".").append(this.columName);
        return sb.toString().toUpperCase();
    }

    public String getColumAsName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.lnkRecordMap.getTableName()).append("_").append(this.columName);
        return sb.toString().toUpperCase();
    }

    public RecordMap getRecordMap() {
        return this.lnkRecordMap;
    }

    public void setRecordMap(RecordMap lnkRecordMap) {
        this.lnkRecordMap = lnkRecordMap;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public RecordMap getLnkRecordMap() {
        return this.lnkRecordMap;
    }

    public void setLnkRecordMap(RecordMap lnkRecordMap) {
        this.lnkRecordMap = lnkRecordMap;
    }

    public void setColumName(String columName) {
        this.columName = columName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isForignKey() {
        return this.forignKey;
    }

    public void setForignKey(boolean forignKey) {
        this.forignKey = forignKey;
    }

    public String getFkPropertyName() {
        return this.fkPropertyName;
    }

    public void setFkPropertyName(String fkPropertyName) {
        this.fkPropertyName = fkPropertyName;
    }
}

