/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.dao.EntityInfo;
import org.itscool.commons.dao.RecordMap;
import org.itscool.commons.dao.RecordMapFactory;
import org.itscool.commons.dao.RecordMapFkFactory;

public class EntityInfoMapping {
    public static final String DB_HSQL = "hsql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_PGSQL = "pgsql";
    public static final String DB_ORACLE = "oracle";
    private HashMap daoInfoMappings = new HashMap();
    private String dbType = "hsql";
    private static EntityInfoMapping instance;

    public static synchronized EntityInfoMapping getInstance() {
        if (instance == null) {
            instance = new EntityInfoMapping();
        }
        return instance;
    }

    public void put(Object key, Object data) {
        this.getDaoInfoMappings().put(key, data);
    }

    public Set keySet() {
        return this.getDaoInfoMappings().keySet();
    }

    public Object get(Object key) {
        return this.getDaoInfoMappings().get(key);
    }

    public void clear() {
        this.getDaoInfoMappings().clear();
    }

    public EntityInfo getDaoInfo(String clazzName) {
        EntityInfo daoInfo = (EntityInfo)this.get(clazzName);
        return daoInfo;
    }

    public RecordMap getGRecordMap(String clazzName) {
        EntityInfo daoInfo = this.getDaoInfo(clazzName);
        return daoInfo.getGRecordMap();
    }

    public HashMap getFkRecordMaps(String clazzName) {
        EntityInfo daoInfo = this.getDaoInfo(clazzName);
        return daoInfo.getFkRecordMaps();
    }

    public RecordMap getGRecordMap(Class clazz) {
        EntityInfo daoInfo = this.getDaoInfo(clazz.getName());
        if (daoInfo == null) {
            return null;
        }
        return daoInfo.getGRecordMap();
    }

    public HashMap getFkRecordMaps(Class clazz) {
        EntityInfo daoInfo = this.getDaoInfo(clazz.getName());
        if (daoInfo == null) {
            return null;
        }
        return daoInfo.getFkRecordMaps();
    }

    public HashMap getDaoInfoMappings() {
        return this.daoInfoMappings;
    }

    public void setDaoInfoMappings(HashMap daoInfoMappings) {
        Set keySet = daoInfoMappings.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String entity = (String)it.next();
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            EntityInfo daoInfo = new EntityInfo();
            daoInfo.setGRecordMap(gRecordMap);
            daoInfo.setFkRecordMaps(fkRecordMaps);
            this.daoInfoMappings.put(entity, daoInfo);
        }
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

