package org.itscool.commons.request;

import java.io.ByteArrayOutputStream;

import org.itscool.commons.util.ByteUtil;
import org.itscool.commons.util.URLDecodeUtil;

/**
 * }`p[g`̃NGXgp[^͂NXł
 *
 * @author Michiaki Kanou
 * @version 1.00A 2005/12/01 VK쐬
 * @version 2.00A 2006/10/12 oCi[^Cṽt@C]Ήǉ
 */
public class MultiHttpGeneralForm extends HttpGeneralForm{
    public static final String DISPOSTION="Content-Disposition";
    public static final String TYPE="Content-Type";
    
    /**
     * ȉBean̂parseData() methodȂ̂ł̒g𗝉邽߂ɂ
     * HTTPvgR̗KvłB
     * ͕iƂĎgĂ邾łB
     * ɏoĂ̂ĝ́hԗւ̍ĔhȂƂ
     * ́A@ƍl܂B
     * @parseData()łstartLinefileLiněo13(x0D)10(x0A)܂CR,
     * LFgĂ܂B
     * HTTP̃bZ[WƂ̂CR, LFŁh؂āhƂƂӖ
     * Ă܂B
     * ɂ̂悤ȕ@ŃbZ[W̋؂茟ooƂƂ̓oCi
     * t@CR[hɕϊ܂璷Ȍ`ɕϊđMĂƌ
     * ŁAϊꂽXg[łCR, LF̕V[PX͌Ȃ悤ɂȂ
     * ĂƌƂɂȂ܂ˁB
     * ̊ɂ̓T[oŌ̃oCi`ɕ鏈ׂ͈ĂȂ̂ŁA
     * ƓB
     * @param buffer
     */
    public void doParseData(byte[] buffer, String encode){
        int pos=0;
        int bufSize = buffer.length;
        
        for(pos=0; pos<=bufSize; ){
            byte[] header = ByteUtil.getLineCrLf(buffer, pos);
            pos += header.length + ByteUtil.LINE.length;
            byte[] dispostion = ByteUtil.getLineCrLf(buffer, pos);
            pos += dispostion.length + ByteUtil.LINE.length;
            byte[] type = ByteUtil.getLineCrLf(buffer, pos);
            pos += type.length + ByteUtil.LINE.length;
            
//			System.out.println("[HEADER]"+new String(header));
//			System.out.println("[DISPOS]"+new String(dispostion));
//			System.out.println("[TYPE  ]"+new String(type));
            
            String dispostionStr = new String(dispostion);
            if( dispostionStr==null || dispostionStr.trim().length() == 0){
                return;
            }
            byte[] data;
            if( (new String(type)).indexOf(TYPE) == 0 ){
                byte[] non = ByteUtil.getLineCrLf(buffer, pos);
                pos += non.length + ByteUtil.LINE.length;
                data = ByteUtil.copyByteData(buffer, pos, buffer.length-pos);
                //System.out.println(new String(data));
                data = getFormData(data, header);
//				pos += data.length + LINE.length;
                pos += data.length + 1;
                
                String key=getKey(dispostionStr);
                key = URLDecodeUtil.filter(key);
                String fileName = getFileName(dispostionStr);
                if(fileName==null || fileName.length()==0){
                    continue;
                }
                UploadFile file = new UploadFile();
                try{
                    file.setData(data);
                }catch(Exception e){
                    e.printStackTrace();
                }
                file.setFileName(fileName);
                file.setSize(data.length);
                addParameter(key, file);
            }else{
                data = ByteUtil.getLineCrLf(buffer, pos);
                pos += data.length + ByteUtil.LINE.length;
                //NGXgp[^Zbg
                String key=getKey(new String(dispostion));
                key = URLDecodeUtil.filter(key);
                String dataStr = URLDecodeUtil.filter(new String(data));
                addParameter(key, dataStr);
            }
            
//			System.out.println("[DATA  ]"+new String(data));
        }
    }
    
    
    /**
     * }`p[gf[^𒊏o܂
     * @param buffer }`p[gf[^̊Jnn܂oCgz
     * @param header Î߂̃wb_
     * @return }`p[gf[^Ԃ܂
     */
    protected static byte[] getFormData(byte[] buffer, byte[] header){
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        
        int endPos = ByteUtil.indexof(buffer, header);
        byte[] byteArray = ByteUtil.copyByteData(buffer, 0, endPos);
        
        return byteArray;
    }
    
    /**
     * uContent-DispositionvLqfilename擾܂
     * @param disposition uContent-DispositionvLq
     * @return filenameԂ܂
     */
    private String getFileName(String disposition){
        int idx=disposition.lastIndexOf(System.getProperty("file.separator"));
        if(idx == -1){
            //return null;
            idx = disposition.lastIndexOf("filename=");
            idx = idx + ("filename=").length();
        }
        String fileName=disposition.substring(idx+1,disposition.length()-1);
        
        return fileName;
    }
    
    /**
     * uContent-DispositionvLqname擾
     * @param disposition uContent-DispositionvLq
     * @return nameԂ܂
     */
    private String getKey(String disposition){
        int start = disposition.indexOf("name=\"");
        String stack = disposition.substring(start + ("name=\"").length(),
            disposition.length());
        int end = stack.indexOf("\"");
        
        String key = stack.substring(0, end);
        
        return key;
    }
    
}
