package org.itscool.commons.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.itscool.commons.dao.EntityInfo;

/**
 * iΏۃNX̏ێHashMapNXł
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2005/10/10
 */
public class EntityInfoMapping{
    public static final String DB_HSQL = "hsql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_PGSQL = "pgsql";
    public static final String DB_ORACLE = "oracle";
    
    private HashMap daoInfoMappings = new HashMap();
    private String dbType = DB_HSQL;
    
    /** BDaoInfoMappingCX^X */
    private static EntityInfoMapping instance;
    
    /**
     * BDaoInfoMappingCX^X擾܂
     * @return DaoInfoMappingCX^X
     */
    public static synchronized EntityInfoMapping getInstance(){
        if( instance == null ){
            instance = new EntityInfoMapping();
        }
        return instance;
    }    

    public void put(Object key, Object data){
        getDaoInfoMappings().put(key, data);
    }
    
    public Set keySet(){
        return getDaoInfoMappings().keySet();
    }
    
    public Object get(Object key){
        return getDaoInfoMappings().get(key);
    }
    
    public void clear(){
        getDaoInfoMappings().clear();
    }
    
    /**
     * iΏۃNX擾܂
     * @param clazzName iΏۃNX
     * @return iΏۃNX
     */
    public EntityInfo getDaoInfo(String clazzName){
        EntityInfo daoInfo = (EntityInfo)this.get(clazzName);
        return daoInfo;
    }
    
    /**
     * iΏۃNXO/R}bsO擾܂
     * @param clazzName iΏۃNX
     * @return iΏۃNXO/R}bsO
     */
    public RecordMap getGRecordMap(String clazzName){
        EntityInfo daoInfo = getDaoInfo(clazzName);
        return daoInfo.getGRecordMap();
    }
    
    /**
     * iΏۃNX̊OQƂƂȂO/R}bsO擾܂
     * @param clazzName iΏۃNX
     * @return iΏۃNX̊OQƂƂȂO/R}bsO
     */
    public HashMap getFkRecordMaps(String clazzName){
        EntityInfo daoInfo = getDaoInfo(clazzName);
        return daoInfo.getFkRecordMaps();
    }
    
    /**
     * iΏۃNXO/R}bsO擾܂
     * @param clazz iΏۃNX
     * @return iΏۃNXO/R}bsO
     */
    public RecordMap getGRecordMap(Class clazz){
        EntityInfo daoInfo = getDaoInfo(clazz.getName());
        if(daoInfo == null) return null;
        return daoInfo.getGRecordMap();
    }
    
    /**
     * iΏۃNX̊OQƂƂȂO/R}bsO擾܂
     * @param clazz iΏۃNX
     * @return iΏۃNX̊OQƂƂȂO/R}bsO
     */
    public HashMap getFkRecordMaps(Class clazz){
        EntityInfo daoInfo = getDaoInfo(clazz.getName());
        if(daoInfo == null) return null;
        return daoInfo.getFkRecordMaps();
    }
    
    public HashMap getDaoInfoMappings() {
        return daoInfoMappings;
    }
    
    public void setDaoInfoMappings(HashMap daoInfoMappings) {
//        this.daoInfoMappings = daoInfoMappings;
        Set keySet = daoInfoMappings.keySet();
        Iterator it = keySet.iterator();
        while(it.hasNext()){
            String entity = (String)it.next();
            RecordMap gRecordMap = RecordMapFactory.createRecordMap(entity);
            HashMap fkRecordMaps = RecordMapFkFactory.createFkRecordMaps(entity);
            EntityInfo daoInfo = new EntityInfo();
            daoInfo.setGRecordMap(gRecordMap);
            daoInfo.setFkRecordMaps(fkRecordMaps);

            this.daoInfoMappings.put( entity, daoInfo );
        }
    }

    public String getDbType() {
        return dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}
