package org.itscool.commons.connection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

/**
 * ConnectionCX^Xւ̃gUNV@\񋟂NXł<br/>
 *
 * <p>
 * java.sql.ConnectionCX^XێĂATransactionNX̊e
 * \bhsƂɂ̃CX^Xg܂B<br/>
 * </p>
 *
 * @author KANO
 * @since jdk1.4.1
 * @version 1.00A 2004/11/1
 */
public class Transaction {
    protected AbstractLog log = SimpleLog.getInstance();
    /**
     * ̃CX^XŁAgUNV͏ĂȂƂ\܂
     */
    public static int NON_PROCESS = 0;
    /**
     * ̃CX^XŁAgUNV{ꂩR~bg\ł邱
     * \܂
     */
    public static int PLEASE_COMMIT = 1;
    /**
     * ̃CX^XŁAgUNV{ꂽsA[obN
     * Ȃ΂ȂȂԂł邱Ƃ\Ă܂
     */
    public static int PLEASE_ROLLBACK = 2;
    
    /**
     * ̃CX^X݂̌̃Xe[^X
     */
    protected int tranStatus = NON_PROCESS;
    /**
     * ConnectionCX^X
     */
    protected Connection connection = null;
    /**
     * gUNVsSQL\[h
     */
    protected boolean showSql;
    
    /**
     * gUNV̏s܂
     * @param con connectionCX^X
     */
    public Transaction(Connection con){
        this.connection = con;
    }
    
    public void setShowSql(boolean showSql){
        this.showSql = showSql;
    }
    
    /**
     * R~bgs܂<BR>
     * @throws SQLException
     */
    public void commit() throws TransactionException{
        try{
            
            //gUNVXe[^X
            this.setTranStatus(NON_PROCESS);
            
            // R~bg܂
            connection.commit();
        }catch(SQLException e){
            log.error(e.getMessage());
            throw new TransactionException(e);
        }
    }
    
    /**
     * [obNs܂
     * @throws SQLException
     */
    public void rollback() throws TransactionException{
        try{
            
            //gUNVXe[^X
            this.setTranStatus(NON_PROCESS);
            
            connection.rollback();
        }catch(SQLException se){
            log.error(se.getMessage());
            throw new TransactionException(se);
        }
    }
    
    /**
     * Statement.executeUpdate(sql)s܂
     * @param sql SQL
     * @throws SQLException
     */
    public int execute(String sql) throws TransactionException{
        Statement stmt = null;
        try{
            if(showSql){
                System.out.println("-------------------------------");
                System.out.println(sql);
            }
            //Xe[ggIuWFNg𐶐
            stmt = connection.createStatement();
            //SQLs
            int recNum = stmt.executeUpdate(sql);
            
            this.setTranStatus(PLEASE_COMMIT);
            
            return recNum;
        }catch(SQLException se){
            log.error(se.getMessage());
            this.setTranStatus(PLEASE_ROLLBACK);
            
            closeStatement(stmt);
            throw new TransactionException(se.getMessage(), sql);
            
        }finally{
            closeStatement(stmt);
        }
    }
    
    public Record selectOne(String sql) throws TransactionException{
        Records records = select(sql);
        if( records.size() > 0 ){
            return records.getRecord(0);
        }else{
            return null;
        }
    }
    
    /**
     * SELECTXe[gg𔭍s܂<BR>
     * sʂLinkedListŕԂ܂<BR>
     * ̃R[hHashMap`ƂȂĂAtB[h̕ʖiASŎw
     * OjHashMap̃L[ƂȂ܂B
     * tB[h̕ʖw肳ĂȂꍇ̓tB[hHashMap̃L[ƂȂ
     * ܂iselectłASgătB[h̕ʖgp邱Ƃ𐄏܂jB
     * @param sql SQL
     * @return sʂLinkedListŕԂ܂B
     * @throws SQLException
     */
    public Records select(String sql) throws TransactionException{
        Records result = new Records();
        Statement stmt = null;
        ResultSet rs = null;
        
        try{
            if(showSql){
                System.out.println("-------------------------------");
                System.out.println(sql);
            }
            //Xe[ggIuWFNg𐶐
            stmt = connection.createStatement();
            //SQLs
            rs = stmt.executeQuery(sql);
            
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            
            while( rs.next() ){
                Record record = new Record();
                //ʃR[h̏WHashMapō쐬
                for(int i=0;i<columnCount;i++){
                    String colName = metaData.getColumnName(i+1);
                    String colAsName = metaData.getColumnLabel(i+1);
                    
                    //񖼂ɕʖw肳Ăꍇ͕ʖgp
                    //Wv֐̏ꍇ͕Kʖw肷ׂł
                    if(!colAsName.equals("")){
                        colName = colAsName;
                    }
                    String value = rs.getString(colName);    //g
//                    //Object value = rs.getObject(colName);    //Bean.setPropertyŌ^̓肪łȂ
//                    System.out.print(colName);
//                    System.out.print(":" + value + " ");
                    
                    //modify 2005/10/12 kanoum start
//                    record.put(colName, value);
                    //SQLs̃JΉ
                    record.put(colName.toUpperCase(), value);
                    //modify 2005/10/12 kanoum end
                }
                result.add(record);
//                System.out.println("");
            }
        }catch(SQLException se){
            closeResultSet(rs);
            closeStatement(stmt);
            throw new TransactionException(se.getMessage(), sql);
        }finally{
            closeResultSet(rs);
            closeStatement(stmt);
        }
        return result;
    }
    
    /**
     * RlNV܂
     * @throws SQLException
     */
    public void close() throws TransactionException{
        try{
            // R~bg܂
            connection.close();
        }catch(SQLException e){
            log.error(e.getMessage());
            throw new TransactionException(e);
        }
    }
    
    public boolean isClosed() throws TransactionException{
        boolean ret = true;
        try{
            if( connection != null ){
                ret = connection.isClosed();
            }
        }catch(SQLException e){
            log.error(e.getMessage());
            throw new TransactionException(e);
        }
        return ret;
    }
    
//    /**
//     * ConnectionCX^X擾܂i񐄏j
//     * @return ConnectionCX^X擾܂i񐄏j
//     */
//    public Connection getConnection() {
//        return connection;
//    }
//
//    /**
//     * ConnectionCX^XZbg܂i񐄏j
//     * @param connection ConnectionCX^XZbg܂
//     */
//    public void setConnection(Connection connection) {
//        this.connection = connection;
//    }
    
    /**
     * StatementCX^XI܂
     * @param stmt StatementCX^X
     * @throws TransactionException IɎsꍇ
     */
    protected void closeStatement(Statement stmt)
    throws TransactionException{
        try{
            if( stmt != null ){
                stmt.close();
                stmt = null;
            }
        }catch(SQLException se){
            log.error(se.getMessage());
            throw new TransactionException(se);
        }
    }
    
    /**
     * ResultSetCX^XI܂
     * @param rs ResultSetCX^X
     * @throws TransactionException IɎsꍇ
     */
    protected void closeResultSet(ResultSet rs)
    throws TransactionException{
        try{
            if( rs != null ){
                rs.close();
                rs = null;
            }
        }catch(SQLException se){
            throw new TransactionException(se);
        }
    }
    
    /**
     * ̃CX^X݂̌̃Xe[^X擾܂
     * @return ݂̃Xe[^XԂ܂
     */
    public int getTranStatus() {
        return tranStatus;
    }
    
    /**
     * ̃CX^X̃Xe[^XXV܂
     * @param tranStatus Xe[^X
     */
    public void setTranStatus(int tranStatus) {
        this.tranStatus = tranStatus;
    }
}
