/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.threadpool;

import org.itscool.commons.threadpool.ClosedException;
import org.itscool.commons.threadpool.FIFOQueue;
import org.itscool.commons.threadpool.ThreadBufferException;
import org.itscool.commons.threadpool.WorkerThread;

public class ThreadPool {
    public static final int DEFAULT_MAX_THREADS = 10;
    private int maxThreads;
    private WorkerThread[] threadPool;
    private FIFOQueue workQueue;

    public ThreadPool(int maxthreadcount) {
        this.maxThreads = maxthreadcount;
        this.threadPool = new WorkerThread[this.maxThreads];
        this.workQueue = new FIFOQueue();
        this.initThreads();
    }

    public ThreadPool(int maxthreadcount, int maxbuffersize) {
        this.maxThreads = maxthreadcount;
        this.threadPool = new WorkerThread[this.maxThreads];
        this.workQueue = new FIFOQueue(maxbuffersize);
        this.initThreads();
    }

    public ThreadPool() {
        this(10, 100);
    }

    private void initThreads() {
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i] = new WorkerThread(this.workQueue);
        }
    }

    public void addRequest(Runnable target) throws ClosedException, ThreadBufferException {
        try {
            this.workQueue.add(target);
        }
        catch (ClosedException ce) {
            throw ce;
        }
        catch (ThreadBufferException tbe) {
            throw tbe;
        }
    }

    public void close() {
        this.stopThreads();
        this.workQueue.close();
    }

    public int close(int waitTime) {
        this.close();
        int sleepTime = 1000;
        int waitCount = 0;
        int i = 0;
        while (sleepTime * i < waitTime && !this.workQueue.requestEmpty()) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedexception) {
                // empty catch block
            }
            ++i;
        }
        while (sleepTime * i < waitTime) {
            for (waitCount = 0; waitCount < this.threadPool.length && this.threadPool[waitCount].getWaitStatus(); ++waitCount) {
            }
            if (waitCount >= this.threadPool.length) break;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedexception) {
                // empty catch block
            }
            ++i;
        }
        return waitCount;
    }

    private void stopThreads() {
        for (int i = 0; i < this.threadPool.length; ++i) {
            this.threadPool[i].setStopped();
        }
    }

    public void printStats() {
        System.out.println("Thread Usage ");
        for (int i = 0; i < this.threadPool.length; ++i) {
            System.out.println(this.threadPool[i].toString());
        }
    }
}

