/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.itscool.commons.connection.Record;
import org.itscool.commons.connection.Records;
import org.itscool.commons.connection.TransactionException;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;

public class Transaction {
    protected AbstractLog log = SimpleLog.getInstance();
    public static int NON_PROCESS = 0;
    public static int PLEASE_COMMIT = 1;
    public static int PLEASE_ROLLBACK = 2;
    protected int tranStatus = NON_PROCESS;
    protected Connection connection = null;
    protected boolean showSql;

    public Transaction(Connection con) {
        this.connection = con;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void commit() throws TransactionException {
        try {
            this.setTranStatus(NON_PROCESS);
            this.connection.commit();
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            throw new TransactionException(e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            this.setTranStatus(NON_PROCESS);
            this.connection.rollback();
        }
        catch (SQLException se) {
            this.log.error(se.getMessage());
            throw new TransactionException(se);
        }
    }

    public int execute(String sql) throws TransactionException {
        int n;
        Statement stmt = null;
        try {
            if (this.showSql) {
                System.out.println("-------------------------------");
                System.out.println(sql);
            }
            stmt = this.connection.createStatement();
            int recNum = stmt.executeUpdate(sql);
            this.setTranStatus(PLEASE_COMMIT);
            n = recNum;
        }
        catch (SQLException se) {
            try {
                this.log.error(se.getMessage());
                this.setTranStatus(PLEASE_ROLLBACK);
                this.closeStatement(stmt);
                throw new TransactionException(se.getMessage(), sql);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        return n;
    }

    public Record selectOne(String sql) throws TransactionException {
        Records records = this.select(sql);
        if (records.size() > 0) {
            return records.getRecord(0);
        }
        return null;
    }

    public Records select(String sql) throws TransactionException {
        Records result = new Records();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (this.showSql) {
                System.out.println("-------------------------------");
                System.out.println(sql);
            }
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                Record record = new Record();
                for (int i = 0; i < columnCount; ++i) {
                    String colName = metaData.getColumnName(i + 1);
                    String colAsName = metaData.getColumnLabel(i + 1);
                    if (!colAsName.equals("")) {
                        colName = colAsName;
                    }
                    String value = rs.getString(colName);
                    record.put(colName.toUpperCase(), value);
                }
                result.add(record);
            }
        }
        catch (SQLException se) {
            try {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                throw new TransactionException(se.getMessage(), sql);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(stmt);
        return result;
    }

    public void close() throws TransactionException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            throw new TransactionException(e);
        }
    }

    public boolean isClosed() throws TransactionException {
        boolean ret = true;
        try {
            if (this.connection != null) {
                ret = this.connection.isClosed();
            }
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            throw new TransactionException(e);
        }
        return ret;
    }

    protected void closeStatement(Statement stmt) throws TransactionException {
        try {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        catch (SQLException se) {
            this.log.error(se.getMessage());
            throw new TransactionException(se);
        }
    }

    protected void closeResultSet(ResultSet rs) throws TransactionException {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException se) {
            throw new TransactionException(se);
        }
    }

    public int getTranStatus() {
        return this.tranStatus;
    }

    public void setTranStatus(int tranStatus) {
        this.tranStatus = tranStatus;
    }
}

