<?php
require_once("apiconfig.php");
require_once("apifunc.php");
require_once 'Lite.php';

// パラメータの値を取得（GET）
$hotelid=$_GET["hotelid"];
$postcode=$_GET["postcode"];
$checkin_date=$_GET["japan_calendar"];
$room_count = $_GET['room_count'];
$adult = $_GET['adult'];
$stay_count = $_GET['stay_count'];

//じゃらんチェックイン年月日
$stt = strtotime($checkin_date);
$jalancheckindate = date("Ymd", $stt);

// じゃらんプランリクエスト
$url="http://jws.jalan.net/APIAdvance/StockSearch/V1/?key=$jalan_apikey&h_id=$hotelid&stay_date=$jalancheckindate&stay_count=$stay_count&adult=$adult&room_count=$room_count";

// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$jalanCache = new Cache_Lite($cacheOptions);

if ($cache = $jalanCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $jalanBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $jalanBuff = file_get_contents($url);
    $jalanCache->save($jalanBuff,$cacheId);
}

$xml = @simplexml_load_string ($jalanBuff);
$hits = $xml->Plan;


foreach ($hits as $hit) { 
$planname[] = h($hit->PlanName);
$plancd[] = h($hit->PlanCD);
$pictureurl = h($hit->PlanPictureURL);
$planurl[] = jalan_pc_aflink($hit->PlanDetailURL,$lstoken);
$roomaname[] = h($hit->RoomName);
$rate[] = h($hit->RateType);
$price[] = h($hit->SampleRate);
$hotelname[] = h($hit->Hotel->HotelName);
$datafrom[] = "じゃらん";
}

// 楽天トラベルで同一ホテルのIDをホテル名と郵便番号から探す
$hotelurlencode=urlencode($hotelname[0]);
$url="http://api.rakuten.co.jp/rws/3.0/rest?developerId=$rwsdevid&operation=KeywordHotelSearch&version=2009-10-20&keyword=$hotelurlencode&searchField=1";

// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$rwsCache = new Cache_Lite($cacheOptions);

if ($cache = $rwsCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $rwsBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $rwsBuff = file_get_contents($url);
    $rwsCache->save($rwsBuff,$cacheId);
}

$rwsBuff = str_replace('header:Header', 'headerHeader', $rwsBuff);
$rwsBuff = str_replace('KeywordHotelSearch:KeywordHotelSearch', 'KeywordHotelSearchKeywordHotelSearch', $rwsBuff);

$xml = simplexml_load_string ($rwsBuff);
$hits = $xml->Body->KeywordHotelSearchKeywordHotelSearch->hotel;

//ひとつずつ情報を取り出して、郵便番号が一致するホテルを特定してそのホテルIDを変数に格納
foreach ($hits as $hit) { 
if ($hit->hotelBasicInfo->postalCode==$postcode) {
$hotelno=h($hit->hotelBasicInfo->hotelNo);
break;
}
}

// 楽天チェックイン年月日
$checkinyymmdd = date("Y-m-d", $stt);

// 楽天チェックアウト年月日
$baseSec = mktime(0, 0, 0, $yoyakumonth, $yoyakudate, $yoyakuyear);
$addSec = $stay_count * 86400;//宿泊数×１日の秒数
$targetSec = $stt + $addSec;
$checkoutyymmdd = date("Y-m-d", $targetSec);


// 楽天トラベルでそのホテルのプランを出して配列変数に代入
$url="http://api.rakuten.co.jp/rws/3.0/rest?developerId=$rwsdevid&affiliateId=$rwsaffid&operation=VacantHotelSearch&version=2009-10-20&hotelNo=$hotelno&checkinDate=$checkinyymmdd&checkoutDate=$checkoutyymmdd";


// キャッシュ＆XMLファイルゲット開始（キャッシュorAPIから）
$cacheId = $url;//リクエストURLがキャッシュのキーとなる
$jalanCache = new Cache_Lite($cacheOptions);

if ($cache = $jalanCache->get($cacheId)) {
    // キャッシュがあればキャッシュからデータを取得
    $jalanBuff = $cache;
} else {
    // キャッシュがなければデータを取りに行き、キャッシュとして保存
    $jalanBuff = file_get_contents($url);
    $jalanCache->save($jalanBuff,$cacheId);
}

$jalanBuff = str_replace('header:Header', 'headerHeader', $jalanBuff);
$jalanBuff= str_replace('vacantHotelSearch:VacantHotelSearch', 'vacantHotelSearchVacantHotelSearch', $jalanBuff);

$xml = simplexml_load_string ($jalanBuff);
$hits = $xml->Body->vacantHotelSearchVacantHotelSearch->hotel->roomInfo;


foreach ($hits as $hit) { 
$planname[] = h($hit->roomBasicInfo->planName);
$plancd[] = h($hit->roomBasicInfo->planId);
$pictureurl = "";
$planurl[] = h($hit->roomBasicInfo->reserveUrl);
$roomaname[] = h($hit->roomBasicInfo->roomName);
$rate[] = "";
$price[] = h($hit->dailyCharge->rakutenCharge);
$hotelname[] = h($hit->Hotel->HotelName);
$datafrom[] = "楽天トラベル";
}

// 値段安い順番に並び替える（全部）
asort($price);


?>
<!DOCTYPE html>
<html lang="ja">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>5travel | <?php echo $hotelname[0]; ?></title>
<link rel="stylesheet" href="style.css" />
<!--[if IE]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->
<script type="text/javascript" src="area_data.js"></script>
<script type="text/javascript" src="area.js"></script>
</head>

<body>

<div id="maincontainer">

<header><div class="innertube"><h1><a href="index.php"><img src="logo.gif" alt="LinkShop" width="292" height="61" border="0" /></a></h1></div></header>

<div id="contentwrapper">
<div id="contentcolumn">
<div class="innertube">


<?php foreach ($price as $key => $value) { ?>
<h3><?php echo $planname[$key]; ?>（<?php echo $plancd[$key]; ?>）</h3>
<?php echo $roomaname[$key]; ?><br>
<?php echo $rate[$key]; ?><?php echo number_format($price[$key]); ?>円<br>
<?php echo $datafrom[$key]; ?>
<a href="<?php echo $planurl[$key]; ?>">予約はこちら・・・</a>

<br crear="all">
<?php } ?>
</div>
</div>
</div>

<nav id="leftcolumn">
<div class="innertube">
左カラム
</div>
</nav>

<nav id="rightcolumn">
<div class="innertube">
右カラム
</div>
</nav>

<footer><a href="http://www.jalan.net/jw/jwp0000/jww0001.do"><img src="http://www.jalan.net/jalan/doc/jws/images/jws_88_50_blue.gif" alt="じゃらん Web サービス" title="じゃらん Web サービス" border="0"></a><!-- Rakuten Web Services Attribution Snippet FROM HERE -->
<a href="http://webservice.rakuten.co.jp/" target="_blank"><img src="http://webservice.rakuten.co.jp/img/credit/200709/credit_7052.gif" border="0" alt="楽天ウェブサービスセンター" title="楽天ウェブサービスセンター" width="70" height="52"/></a>
<!-- Rakuten Web Services Attribution Snippet TO HERE --><br>
<a href="http://www.c-player.com/ad62110/message/">Copyright 2010 WebサービスAPI勉強会第２クール</a></footer>

</div>
</body>
</html>
