/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSData;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            transferDataArray[i] = new TransferData();
            transferDataArray[i].type = nArray[i];
        }
        return transferDataArray;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        for (int i = 0; i < nArray.length; ++i) {
            if (transferData.type != nArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) && !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        NSData nSData = NSData.dataWithBytes(byArray, byArray.length);
        transferData.data = nSData;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data == null) {
            return null;
        }
        NSData nSData = (NSData)transferData.data;
        if (nSData.length() == 0L) {
            return null;
        }
        byte[] byArray = new byte[(int)nSData.length()];
        nSData.getBytes(byArray);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

