/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Sidebar Window.
 *
 * The Initial Developer of the Original Code is SHIMODA Hiroshi.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): SHIMODA Hiroshi <piro@p.club.ne.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var gPanelBoxHeight = 0;

function toggleSidebarWindowCollapsed(aNotToSave)
{
  var panelBox = document.getElementById("sidebar-panels");

  if (panelBox.boxObject.height)
    // Save the height of the panel box
    gPanelBoxHeight = panelBox.boxObject.height;

  if (!aNotToSave) {
    nsPreferences.setBoolPref("sidebar.collapsed", !panelBox.collapsed);
    nsPreferences.setIntPref("sidebar.panelBoxHeight", gPanelBoxHeight);
    nsPreferences.setIntPref("sidebar.width", window.outerWidth);
    nsPreferences.setIntPref("sidebar.height", window.outerHeight);
  }

  window.resizeBy(
    0,
    (panelBox.collapsed ? gPanelBoxHeight : -gPanelBoxHeight )
  );
  panelBox.collapsed = !panelBox.collapsed;
}

function onLoad()
{
  toggleSidebarWindowCheck(true);

  // Bind reference to navigator windows to "window._content", etc.
  OverrideFunctions();

  nsPreferences.setBoolPref("sidebar.show", true);

  try {
    if (nsPreferences.getBoolPref("sidebar.collapsed")) {
      gPanelBoxHeight = nsPreferences.getIntPref("sidebar.panelBoxHeight", gPanelBoxHeight);
      window.resizeTo(
        nsPreferences.getIntPref("sidebar.width"),
        nsPreferences.getIntPref("sidebar.height")
      );
      toggleSidebarWindowCollapsed();
    }
  }
  catch(e) {
  }
}

function onUnload()
{
  toggleSidebarWindowCheck(false);
  if (document.getElementById("sidebar-panels").collapsed)
    toggleSidebarWindowCollapsed(true);

  nsPreferences.setBoolPref("sidebar.show", false);
}



function OverrideFunctions()
{

  window.__defineGetter__("_content", function()
  {
    var contentWindow = getSidebarHostWindow()._content;
    if (contentWindow) {
      contentWindow.framesSelf = contentWindow.frames;
      contentWindow.framesSum = [].concat(contentWindow.framesSelf).concat(window.frames);
      contentWindow.__defineGetter__("frames", function() { return this.framesSum; });
    }
    return contentWindow;
  });

  // The method "isDocumentFrame(frame)" of "_content.frames" checks
  // whether the handed frame is contained in _content.frames, so,
  // it is failed in the Sidebar Window.
  window.__defineGetter__("_content.frames", function()
  {
    var contentWindow = window._content;
    if (contentWindow)
      return [].concat(contentWindow.frames).concat(window.frames);
    else
      return window.frames;
  });


  window.getBrowser = function()
  {
    if (getSidebarHostWindow())
      return getSidebarHostWindow().getBrowser();
    else
      return window.openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no");
  };

  window.loadURI = function(aURI, aReferrer)
  {
    if (getSidebarHostWindow())
      getSidebarHostWindow().loadURI(aURI, aReferrer);
    else
      window.openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no", aURI, "", aReferrer);
  };


  window.SidebarShowHide = window.close;


  if (window.openNewTabWith.toString().match(/navigator:browser/))
    window.openNewTabWith = function(aURI)
    {
      urlSecurityCheck(aURI, document);
      var browser = getBrowser();
      var tab = browser.addTab(url, getReferrer(document));
      if (!nsPreferences.getBoolPref("browser.tabs.loadInBackground"))
        browser.selectedTab = tab;
    };

}
